/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.Region;

@ApiModel(description="The regions that have changed in the right half-open interval: [start_offset, next_offset). ")
public class ChangedRegions {
    @SerializedName(value="file_size")
    private Long fileSize = null;
    @SerializedName(value="next_offset")
    private Long nextOffset = null;
    @SerializedName(value="region_list")
    private List<Region> regionList = new ArrayList<Region>();

    public ChangedRegions fileSize(Long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Size of the file specified by snapshot_file_path")
    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public ChangedRegions nextOffset(Long nextOffset) {
        this.nextOffset = nextOffset;
        return this;
    }

    @ApiModelProperty(example="null", value="The offset from where the client must continue the request. This field will not be set when there are no more changed regions to be returned. Note that the next_offset can be outside the endOffset specified by the client in the request. This helps clients reach the next changed offset faster. ")
    public Long getNextOffset() {
        return this.nextOffset;
    }

    public void setNextOffset(Long nextOffset) {
        this.nextOffset = nextOffset;
    }

    public ChangedRegions regionList(List<Region> regionList) {
        this.regionList = regionList;
        return this;
    }

    @ApiModelProperty(example="null", value="List of regions describing the change for the interval [start_offset, next_offset]. ")
    public List<Region> getRegionList() {
        return this.regionList;
    }

    public void setRegionList(List<Region> regionList) {
        this.regionList = regionList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedRegions changedRegions = (ChangedRegions)o;
        return Objects.equals(this.fileSize, changedRegions.fileSize) && Objects.equals(this.nextOffset, changedRegions.nextOffset) && Objects.equals(this.regionList, changedRegions.regionList);
    }

    public int hashCode() {
        return Objects.hash(this.fileSize, this.nextOffset, this.regionList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangedRegions {\n");
        sb.append("    fileSize: ").append(this.toIndentedString(this.fileSize)).append("\n");
        sb.append("    nextOffset: ").append(this.toIndentedString(this.nextOffset)).append("\n");
        sb.append("    regionList: ").append(this.toIndentedString(this.regionList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

