/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Customer information used in Certificate Signing Request for creating digital certificates. ")
public class CertificationSigningInfo {
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="common_name")
    private String commonName = null;
    @SerializedName(value="common_name_suffix")
    private String commonNameSuffix = null;
    @SerializedName(value="country_code")
    private String countryCode = null;
    @SerializedName(value="email_address")
    private String emailAddress = null;
    @SerializedName(value="organization")
    private String organization = null;
    @SerializedName(value="state")
    private String state = null;

    public CertificationSigningInfo city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(example="null", value="The Town or City where customer's business is located.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public CertificationSigningInfo commonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    @ApiModelProperty(example="null", value="Common name of the organization or host server")
    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public CertificationSigningInfo commonNameSuffix(String commonNameSuffix) {
        this.commonNameSuffix = commonNameSuffix;
        return this;
    }

    @ApiModelProperty(example="null", value="Common name is by default <node_uuid>.nutanix.com, but if a customer wants something instead of nutanix.com they can specify it here. ")
    public String getCommonNameSuffix() {
        return this.commonNameSuffix;
    }

    public void setCommonNameSuffix(String commonNameSuffix) {
        this.commonNameSuffix = commonNameSuffix;
    }

    public CertificationSigningInfo countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Two-letter ISO code for Country where customer's organization is located. ")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public CertificationSigningInfo emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Email address of the certificate administrator.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public CertificationSigningInfo organization(String organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the customer business.")
    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public CertificationSigningInfo state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The Province, Region, County or State where customer business is is located. ")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificationSigningInfo certificationSigningInfo = (CertificationSigningInfo)o;
        return Objects.equals(this.city, certificationSigningInfo.city) && Objects.equals(this.commonName, certificationSigningInfo.commonName) && Objects.equals(this.commonNameSuffix, certificationSigningInfo.commonNameSuffix) && Objects.equals(this.countryCode, certificationSigningInfo.countryCode) && Objects.equals(this.emailAddress, certificationSigningInfo.emailAddress) && Objects.equals(this.organization, certificationSigningInfo.organization) && Objects.equals(this.state, certificationSigningInfo.state);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.commonName, this.commonNameSuffix, this.countryCode, this.emailAddress, this.organization, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CertificationSigningInfo {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    commonName: ").append(this.toIndentedString(this.commonName)).append("\n");
        sb.append("    commonNameSuffix: ").append(this.toIndentedString(this.commonNameSuffix)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

