/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="Cluster build details.")
public class BuildInfo {
    @SerializedName(value="build_type")
    private String buildType = null;
    @SerializedName(value="commit_date")
    private DateTime commitDate = null;
    @SerializedName(value="commit_id")
    private String commitId = null;
    @SerializedName(value="short_commit_id")
    private String shortCommitId = null;
    @SerializedName(value="version")
    private String version = null;

    public BuildInfo buildType(String buildType) {
        this.buildType = buildType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Build type, one of {dbg, opt, release}.")
    public String getBuildType() {
        return this.buildType;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public BuildInfo commitDate(DateTime commitDate) {
        this.commitDate = commitDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date/time of the last commit.")
    public DateTime getCommitDate() {
        return this.commitDate;
    }

    public void setCommitDate(DateTime commitDate) {
        this.commitDate = commitDate;
    }

    public BuildInfo commitId(String commitId) {
        this.commitId = commitId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Last Git commit id which the build is based on.")
    public String getCommitId() {
        return this.commitId;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    public BuildInfo shortCommitId(String shortCommitId) {
        this.shortCommitId = shortCommitId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="First 6 characters of the last Git commit id.")
    public String getShortCommitId() {
        return this.shortCommitId;
    }

    public void setShortCommitId(String shortCommitId) {
        this.shortCommitId = shortCommitId;
    }

    public BuildInfo version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version string in format <code_name>-<version_numbers>-<branch_type>, i.e master, danube-4.5.0.2-stable ")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildInfo buildInfo = (BuildInfo)o;
        return Objects.equals(this.buildType, buildInfo.buildType) && Objects.equals(this.commitDate, buildInfo.commitDate) && Objects.equals(this.commitId, buildInfo.commitId) && Objects.equals(this.shortCommitId, buildInfo.shortCommitId) && Objects.equals(this.version, buildInfo.version);
    }

    public int hashCode() {
        return Objects.hash(this.buildType, this.commitDate, this.commitId, this.shortCommitId, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuildInfo {\n");
        sb.append("    buildType: ").append(this.toIndentedString(this.buildType)).append("\n");
        sb.append("    commitDate: ").append(this.toIndentedString(this.commitDate)).append("\n");
        sb.append("    commitId: ").append(this.toIndentedString(this.commitId)).append("\n");
        sb.append("    shortCommitId: ").append(this.toIndentedString(this.shortCommitId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

