/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.ApiRequest;

@ApiModel(description="Request for batch operations.")
public class BatchRequest {
    @SerializedName(value="action_on_failure")
    private String actionOnFailure = "CONTINUE";
    @SerializedName(value="api_request_list")
    private List<ApiRequest> apiRequestList = new ArrayList<ApiRequest>();
    @SerializedName(value="api_version")
    private String apiVersion = null;
    @SerializedName(value="execution_order")
    private String executionOrder = "SEQUENTIAL";

    public BatchRequest actionOnFailure(String actionOnFailure) {
        this.actionOnFailure = actionOnFailure;
        return this;
    }

    @ApiModelProperty(example="null", value="If the specified parameter is CONTINUE, the remaining APIs in the batch continue to be executed. ")
    public String getActionOnFailure() {
        return this.actionOnFailure;
    }

    public void setActionOnFailure(String actionOnFailure) {
        this.actionOnFailure = actionOnFailure;
    }

    public BatchRequest apiRequestList(List<ApiRequest> apiRequestList) {
        this.apiRequestList = apiRequestList;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of API requests in the batch.")
    public List<ApiRequest> getApiRequestList() {
        return this.apiRequestList;
    }

    public void setApiRequestList(List<ApiRequest> apiRequestList) {
        this.apiRequestList = apiRequestList;
    }

    @ApiModelProperty(example="null", required=true, value="The current API version.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public BatchRequest executionOrder(String executionOrder) {
        this.executionOrder = executionOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The order of execution of the APIs in the batch. Can be either Sequential (default value) or Parallel. ")
    public String getExecutionOrder() {
        return this.executionOrder;
    }

    public void setExecutionOrder(String executionOrder) {
        this.executionOrder = executionOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRequest batchRequest = (BatchRequest)o;
        return Objects.equals(this.actionOnFailure, batchRequest.actionOnFailure) && Objects.equals(this.apiRequestList, batchRequest.apiRequestList) && Objects.equals(this.apiVersion, batchRequest.apiVersion) && Objects.equals(this.executionOrder, batchRequest.executionOrder);
    }

    public int hashCode() {
        return Objects.hash(this.actionOnFailure, this.apiRequestList, this.apiVersion, this.executionOrder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchRequest {\n");
        sb.append("    actionOnFailure: ").append(this.toIndentedString(this.actionOnFailure)).append("\n");
        sb.append("    apiRequestList: ").append(this.toIndentedString(this.apiRequestList)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    executionOrder: ").append(this.toIndentedString(this.executionOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

