/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Reference;

@ApiModel(description="Attached iSCSI initiators.")
public class AttachmentReference {
    @SerializedName(value="iscsi_initiator_name")
    private String iscsiInitiatorName = null;
    @SerializedName(value="vm_reference")
    private Reference vmReference = null;

    public AttachmentReference iscsiInitiatorName(String iscsiInitiatorName) {
        this.iscsiInitiatorName = iscsiInitiatorName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the iSCSI initiator of the workload outside Nutanix cluster. ")
    public String getIscsiInitiatorName() {
        return this.iscsiInitiatorName;
    }

    public void setIscsiInitiatorName(String iscsiInitiatorName) {
        this.iscsiInitiatorName = iscsiInitiatorName;
    }

    public AttachmentReference vmReference(Reference vmReference) {
        this.vmReference = vmReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Reference getVmReference() {
        return this.vmReference;
    }

    public void setVmReference(Reference vmReference) {
        this.vmReference = vmReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentReference attachmentReference = (AttachmentReference)o;
        return Objects.equals(this.iscsiInitiatorName, attachmentReference.iscsiInitiatorName) && Objects.equals(this.vmReference, attachmentReference.vmReference);
    }

    public int hashCode() {
        return Objects.hash(this.iscsiInitiatorName, this.vmReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentReference {\n");
        sb.append("    iscsiInitiatorName: ").append(this.toIndentedString(this.iscsiInitiatorName)).append("\n");
        sb.append("    vmReference: ").append(this.toIndentedString(this.vmReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

