/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import nutanix.model.ProjectReference;
import nutanix.model.UserReference;
import org.joda.time.DateTime;

@ApiModel(description="The app_blueprint kind metadata")
public class AppBlueprintMetadata {
    @SerializedName(value="categories")
    private Map<String, String> categories = new HashMap<String, String>();
    @SerializedName(value="creation_time")
    private DateTime creationTime = null;
    @SerializedName(value="kind")
    private String kind = "app_blueprint";
    @SerializedName(value="last_update_time")
    private DateTime lastUpdateTime = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="owner_reference")
    private UserReference ownerReference = null;
    @SerializedName(value="project_reference")
    private ProjectReference projectReference = null;
    @SerializedName(value="spec_version")
    private Integer specVersion = null;
    @SerializedName(value="uuid")
    private String uuid = null;

    public AppBlueprintMetadata categories(Map<String, String> categories) {
        this.categories = categories;
        return this;
    }

    @ApiModelProperty(example="null", value="Categories for the app_blueprint")
    public Map<String, String> getCategories() {
        return this.categories;
    }

    public void setCategories(Map<String, String> categories) {
        this.categories = categories;
    }

    @ApiModelProperty(example="null", value="Time when app_blueprint was created")
    public DateTime getCreationTime() {
        return this.creationTime;
    }

    @ApiModelProperty(example="null", required=true, value="The kind name")
    public String getKind() {
        return this.kind;
    }

    @ApiModelProperty(example="null", value="Time when app_blueprint was last updated")
    public DateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @ApiModelProperty(example="null", value="app_blueprint name")
    public String getName() {
        return this.name;
    }

    public AppBlueprintMetadata ownerReference(UserReference ownerReference) {
        this.ownerReference = ownerReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public UserReference getOwnerReference() {
        return this.ownerReference;
    }

    public void setOwnerReference(UserReference ownerReference) {
        this.ownerReference = ownerReference;
    }

    public AppBlueprintMetadata projectReference(ProjectReference projectReference) {
        this.projectReference = projectReference;
        return this;
    }

    @ApiModelProperty(example="null", value="The project the app_blueprint is in.")
    public ProjectReference getProjectReference() {
        return this.projectReference;
    }

    public void setProjectReference(ProjectReference projectReference) {
        this.projectReference = projectReference;
    }

    public AppBlueprintMetadata specVersion(Integer specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Version number of the latest spec")
    public Integer getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(Integer specVersion) {
        this.specVersion = specVersion;
    }

    public AppBlueprintMetadata uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @ApiModelProperty(example="null", value="app_blueprint UUID")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppBlueprintMetadata appBlueprintMetadata = (AppBlueprintMetadata)o;
        return Objects.equals(this.categories, appBlueprintMetadata.categories) && Objects.equals(this.creationTime, appBlueprintMetadata.creationTime) && Objects.equals(this.kind, appBlueprintMetadata.kind) && Objects.equals(this.lastUpdateTime, appBlueprintMetadata.lastUpdateTime) && Objects.equals(this.name, appBlueprintMetadata.name) && Objects.equals(this.ownerReference, appBlueprintMetadata.ownerReference) && Objects.equals(this.projectReference, appBlueprintMetadata.projectReference) && Objects.equals(this.specVersion, appBlueprintMetadata.specVersion) && Objects.equals(this.uuid, appBlueprintMetadata.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.categories, this.creationTime, this.kind, this.lastUpdateTime, this.name, this.ownerReference, this.projectReference, this.specVersion, this.uuid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppBlueprintMetadata {\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    lastUpdateTime: ").append(this.toIndentedString(this.lastUpdateTime)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerReference: ").append(this.toIndentedString(this.ownerReference)).append("\n");
        sb.append("    projectReference: ").append(this.toIndentedString(this.projectReference)).append("\n");
        sb.append("    specVersion: ").append(this.toIndentedString(this.specVersion)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

