/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="API request")
public class ApiRequest {
    @SerializedName(value="body")
    private Map<String, Object> body = new HashMap<String, Object>();
    @SerializedName(value="operation")
    private String operation = null;
    @SerializedName(value="path_and_params")
    private String pathAndParams = null;

    public ApiRequest body(Map<String, Object> body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="null", value="The API request specification.")
    public Map<String, Object> getBody() {
        return this.body;
    }

    public void setBody(Map<String, Object> body) {
        this.body = body;
    }

    public ApiRequest operation(String operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The REST method to use.")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public ApiRequest pathAndParams(String pathAndParams) {
        this.pathAndParams = pathAndParams;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The part of the API request that contains information such as the path and query. ")
    public String getPathAndParams() {
        return this.pathAndParams;
    }

    public void setPathAndParams(String pathAndParams) {
        this.pathAndParams = pathAndParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRequest apiRequest = (ApiRequest)o;
        return Objects.equals(this.body, apiRequest.body) && Objects.equals(this.operation, apiRequest.operation) && Objects.equals(this.pathAndParams, apiRequest.pathAndParams);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.operation, this.pathAndParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRequest {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    pathAndParams: ").append(this.toIndentedString(this.pathAndParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

