/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Host address.")
public class Address {
    @SerializedName(value="fqdn")
    private String fqdn = null;
    @SerializedName(value="ip")
    private String ip = null;
    @SerializedName(value="ipv6")
    private String ipv6 = null;
    @SerializedName(value="port")
    private Integer port = null;

    public Address fqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    @ApiModelProperty(example="null", value="Fully qualified domain name.")
    public String getFqdn() {
        return this.fqdn;
    }

    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
    }

    public Address ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(example="null", value="IPV4 address.")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Address ipv6(String ipv6) {
        this.ipv6 = ipv6;
        return this;
    }

    @ApiModelProperty(example="null", value="IPV6 address.")
    public String getIpv6() {
        return this.ipv6;
    }

    public void setIpv6(String ipv6) {
        this.ipv6 = ipv6;
    }

    public Address port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(example="null", value="Port Number")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.fqdn, address.fqdn) && Objects.equals(this.ip, address.ip) && Objects.equals(this.ipv6, address.ipv6) && Objects.equals(this.port, address.port);
    }

    public int hashCode() {
        return Objects.hash(this.fqdn, this.ip, this.ipv6, this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    fqdn: ").append(this.toIndentedString(this.fqdn)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    ipv6: ").append(this.toIndentedString(this.ipv6)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

