/*
 * Decompiled with CFR 0.152.
 */
package nutanix.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import nutanix.ApiCallback;
import nutanix.ApiClient;
import nutanix.ApiException;
import nutanix.ApiResponse;
import nutanix.Configuration;
import nutanix.Pair;
import nutanix.ProgressRequestBody;
import nutanix.ProgressResponseBody;
import nutanix.model.VolumeGroupIntentInput;
import nutanix.model.VolumeGroupIntentResponse;
import nutanix.model.VolumeGroupListIntentResponse;
import nutanix.model.VolumeGroupListMetadata;

public class VolumegroupApi {
    private ApiClient apiClient;

    public VolumegroupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VolumegroupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createVolumeGroupCall(VolumeGroupIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        VolumeGroupIntentInput localVarPostBody = body;
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createVolumeGroup(Async)");
        }
        String localVarPath = "/volume_groups".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public VolumeGroupIntentResponse createVolumeGroup(VolumeGroupIntentInput body) throws ApiException {
        ApiResponse<VolumeGroupIntentResponse> resp = this.createVolumeGroupWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<VolumeGroupIntentResponse> createVolumeGroupWithHttpInfo(VolumeGroupIntentInput body) throws ApiException {
        Call call = this.createVolumeGroupCall(body, null, null);
        Type localVarReturnType = new TypeToken<VolumeGroupIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createVolumeGroupAsync(VolumeGroupIntentInput body, final ApiCallback<VolumeGroupIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createVolumeGroupCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<VolumeGroupIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteVolumeGroupCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteVolumeGroup(Async)");
        }
        String localVarPath = "/volume_groups/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteVolumeGroup(String uuid) throws ApiException {
        this.deleteVolumeGroupWithHttpInfo(uuid);
    }

    public ApiResponse<Void> deleteVolumeGroupWithHttpInfo(String uuid) throws ApiException {
        Call call = this.deleteVolumeGroupCall(uuid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteVolumeGroupAsync(String uuid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteVolumeGroupCall(uuid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getVolumeGroupCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getVolumeGroup(Async)");
        }
        String localVarPath = "/volume_groups/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public VolumeGroupIntentResponse getVolumeGroup(String uuid) throws ApiException {
        ApiResponse<VolumeGroupIntentResponse> resp = this.getVolumeGroupWithHttpInfo(uuid);
        return resp.getData();
    }

    public ApiResponse<VolumeGroupIntentResponse> getVolumeGroupWithHttpInfo(String uuid) throws ApiException {
        Call call = this.getVolumeGroupCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<VolumeGroupIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getVolumeGroupAsync(String uuid, final ApiCallback<VolumeGroupIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getVolumeGroupCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<VolumeGroupIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call listVolumeGroupCall(VolumeGroupListMetadata getEntitiesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        VolumeGroupListMetadata localVarPostBody = getEntitiesRequest;
        if (getEntitiesRequest == null) {
            throw new ApiException("Missing the required parameter 'getEntitiesRequest' when calling listVolumeGroup(Async)");
        }
        String localVarPath = "/volume_groups/list".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public VolumeGroupListIntentResponse listVolumeGroup(VolumeGroupListMetadata getEntitiesRequest) throws ApiException {
        ApiResponse<VolumeGroupListIntentResponse> resp = this.listVolumeGroupWithHttpInfo(getEntitiesRequest);
        return resp.getData();
    }

    public ApiResponse<VolumeGroupListIntentResponse> listVolumeGroupWithHttpInfo(VolumeGroupListMetadata getEntitiesRequest) throws ApiException {
        Call call = this.listVolumeGroupCall(getEntitiesRequest, null, null);
        Type localVarReturnType = new TypeToken<VolumeGroupListIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listVolumeGroupAsync(VolumeGroupListMetadata getEntitiesRequest, final ApiCallback<VolumeGroupListIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listVolumeGroupCall(getEntitiesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<VolumeGroupListIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateVolumeGroupCall(String uuid, VolumeGroupIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        VolumeGroupIntentInput localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateVolumeGroup(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateVolumeGroup(Async)");
        }
        String localVarPath = "/volume_groups/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public VolumeGroupIntentResponse updateVolumeGroup(String uuid, VolumeGroupIntentInput body) throws ApiException {
        ApiResponse<VolumeGroupIntentResponse> resp = this.updateVolumeGroupWithHttpInfo(uuid, body);
        return resp.getData();
    }

    public ApiResponse<VolumeGroupIntentResponse> updateVolumeGroupWithHttpInfo(String uuid, VolumeGroupIntentInput body) throws ApiException {
        Call call = this.updateVolumeGroupCall(uuid, body, null, null);
        Type localVarReturnType = new TypeToken<VolumeGroupIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateVolumeGroupAsync(String uuid, VolumeGroupIntentInput body, final ApiCallback<VolumeGroupIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateVolumeGroupCall(uuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<VolumeGroupIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

