/*
 * Decompiled with CFR 0.152.
 */
package nutanix.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import nutanix.ApiCallback;
import nutanix.ApiClient;
import nutanix.ApiException;
import nutanix.ApiResponse;
import nutanix.Configuration;
import nutanix.Pair;
import nutanix.ProgressRequestBody;
import nutanix.ProgressResponseBody;
import nutanix.model.SubnetIntentInput;
import nutanix.model.SubnetIntentResponse;
import nutanix.model.SubnetListIntentResponse;
import nutanix.model.SubnetListMetadata;

public class SubnetApi {
    private ApiClient apiClient;

    public SubnetApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubnetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createSubnetCall(SubnetIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SubnetIntentInput localVarPostBody = body;
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSubnet(Async)");
        }
        String localVarPath = "/subnets".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public SubnetIntentResponse createSubnet(SubnetIntentInput body) throws ApiException {
        ApiResponse<SubnetIntentResponse> resp = this.createSubnetWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<SubnetIntentResponse> createSubnetWithHttpInfo(SubnetIntentInput body) throws ApiException {
        Call call = this.createSubnetCall(body, null, null);
        Type localVarReturnType = new TypeToken<SubnetIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSubnetAsync(SubnetIntentInput body, final ApiCallback<SubnetIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSubnetCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubnetIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteSubnetCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteSubnet(Async)");
        }
        String localVarPath = "/subnets/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteSubnet(String uuid) throws ApiException {
        this.deleteSubnetWithHttpInfo(uuid);
    }

    public ApiResponse<Void> deleteSubnetWithHttpInfo(String uuid) throws ApiException {
        Call call = this.deleteSubnetCall(uuid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteSubnetAsync(String uuid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSubnetCall(uuid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getSubnetCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getSubnet(Async)");
        }
        String localVarPath = "/subnets/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public SubnetIntentResponse getSubnet(String uuid) throws ApiException {
        ApiResponse<SubnetIntentResponse> resp = this.getSubnetWithHttpInfo(uuid);
        return resp.getData();
    }

    public ApiResponse<SubnetIntentResponse> getSubnetWithHttpInfo(String uuid) throws ApiException {
        Call call = this.getSubnetCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<SubnetIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSubnetAsync(String uuid, final ApiCallback<SubnetIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSubnetCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubnetIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call listSubnetCall(SubnetListMetadata getEntitiesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SubnetListMetadata localVarPostBody = getEntitiesRequest;
        if (getEntitiesRequest == null) {
            throw new ApiException("Missing the required parameter 'getEntitiesRequest' when calling listSubnet(Async)");
        }
        String localVarPath = "/subnets/list".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public SubnetListIntentResponse listSubnet(SubnetListMetadata getEntitiesRequest) throws ApiException {
        ApiResponse<SubnetListIntentResponse> resp = this.listSubnetWithHttpInfo(getEntitiesRequest);
        return resp.getData();
    }

    public ApiResponse<SubnetListIntentResponse> listSubnetWithHttpInfo(SubnetListMetadata getEntitiesRequest) throws ApiException {
        Call call = this.listSubnetCall(getEntitiesRequest, null, null);
        Type localVarReturnType = new TypeToken<SubnetListIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listSubnetAsync(SubnetListMetadata getEntitiesRequest, final ApiCallback<SubnetListIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listSubnetCall(getEntitiesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubnetListIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateSubnetCall(String uuid, SubnetIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SubnetIntentInput localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateSubnet(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateSubnet(Async)");
        }
        String localVarPath = "/subnets/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public SubnetIntentResponse updateSubnet(String uuid, SubnetIntentInput body) throws ApiException {
        ApiResponse<SubnetIntentResponse> resp = this.updateSubnetWithHttpInfo(uuid, body);
        return resp.getData();
    }

    public ApiResponse<SubnetIntentResponse> updateSubnetWithHttpInfo(String uuid, SubnetIntentInput body) throws ApiException {
        Call call = this.updateSubnetCall(uuid, body, null, null);
        Type localVarReturnType = new TypeToken<SubnetIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateSubnetAsync(String uuid, SubnetIntentInput body, final ApiCallback<SubnetIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateSubnetCall(uuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubnetIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

