/*
 * Decompiled with CFR 0.152.
 */
package nutanix.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import nutanix.ApiCallback;
import nutanix.ApiClient;
import nutanix.ApiException;
import nutanix.ApiResponse;
import nutanix.Configuration;
import nutanix.Pair;
import nutanix.ProgressRequestBody;
import nutanix.ProgressResponseBody;
import nutanix.model.ImageIntentInput;
import nutanix.model.ImageIntentResponse;
import nutanix.model.ImageListIntentResponse;
import nutanix.model.ImageListMetadata;

public class ImagesApi {
    private ApiClient apiClient;

    public ImagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImagesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createImageCall(ImageIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ImageIntentInput localVarPostBody = body;
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createImage(Async)");
        }
        String localVarPath = "/images".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public ImageIntentResponse createImage(ImageIntentInput body) throws ApiException {
        ApiResponse<ImageIntentResponse> resp = this.createImageWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ImageIntentResponse> createImageWithHttpInfo(ImageIntentInput body) throws ApiException {
        Call call = this.createImageCall(body, null, null);
        Type localVarReturnType = new TypeToken<ImageIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createImageAsync(ImageIntentInput body, final ApiCallback<ImageIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createImageCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ImageIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteImageCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteImage(Async)");
        }
        String localVarPath = "/images/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteImage(String uuid) throws ApiException {
        this.deleteImageWithHttpInfo(uuid);
    }

    public ApiResponse<Void> deleteImageWithHttpInfo(String uuid) throws ApiException {
        Call call = this.deleteImageCall(uuid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteImageAsync(String uuid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteImageCall(uuid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call downloadImagefileCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling downloadImagefile(Async)");
        }
        String localVarPath = "/images/{uuid}/file".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public byte[] downloadImagefile(String uuid) throws ApiException {
        ApiResponse<byte[]> resp = this.downloadImagefileWithHttpInfo(uuid);
        return resp.getData();
    }

    public ApiResponse<byte[]> downloadImagefileWithHttpInfo(String uuid) throws ApiException {
        Call call = this.downloadImagefileCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadImagefileAsync(String uuid, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadImagefileCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getImageCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getImage(Async)");
        }
        String localVarPath = "/images/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public ImageIntentResponse getImage(String uuid) throws ApiException {
        ApiResponse<ImageIntentResponse> resp = this.getImageWithHttpInfo(uuid);
        return resp.getData();
    }

    public ApiResponse<ImageIntentResponse> getImageWithHttpInfo(String uuid) throws ApiException {
        Call call = this.getImageCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<ImageIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getImageAsync(String uuid, final ApiCallback<ImageIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getImageCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ImageIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call listImageCall(ImageListMetadata getEntitiesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ImageListMetadata localVarPostBody = getEntitiesRequest;
        if (getEntitiesRequest == null) {
            throw new ApiException("Missing the required parameter 'getEntitiesRequest' when calling listImage(Async)");
        }
        String localVarPath = "/images/list".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public ImageListIntentResponse listImage(ImageListMetadata getEntitiesRequest) throws ApiException {
        ApiResponse<ImageListIntentResponse> resp = this.listImageWithHttpInfo(getEntitiesRequest);
        return resp.getData();
    }

    public ApiResponse<ImageListIntentResponse> listImageWithHttpInfo(ImageListMetadata getEntitiesRequest) throws ApiException {
        Call call = this.listImageCall(getEntitiesRequest, null, null);
        Type localVarReturnType = new TypeToken<ImageListIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listImageAsync(ImageListMetadata getEntitiesRequest, final ApiCallback<ImageListIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listImageCall(getEntitiesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ImageListIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateImageCall(String uuid, ImageIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ImageIntentInput localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateImage(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateImage(Async)");
        }
        String localVarPath = "/images/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public ImageIntentResponse updateImage(String uuid, ImageIntentInput body) throws ApiException {
        ApiResponse<ImageIntentResponse> resp = this.updateImageWithHttpInfo(uuid, body);
        return resp.getData();
    }

    public ApiResponse<ImageIntentResponse> updateImageWithHttpInfo(String uuid, ImageIntentInput body) throws ApiException {
        Call call = this.updateImageCall(uuid, body, null, null);
        Type localVarReturnType = new TypeToken<ImageIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateImageAsync(String uuid, ImageIntentInput body, final ApiCallback<ImageIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateImageCall(uuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ImageIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call uploadImagefileCall(String uuid, byte[] image, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        byte[] localVarPostBody = image;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling uploadImagefile(Async)");
        }
        if (image == null) {
            throw new ApiException("Missing the required parameter 'image' when calling uploadImagefile(Async)");
        }
        String localVarPath = "/images/{uuid}/file".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void uploadImagefile(String uuid, byte[] image) throws ApiException {
        this.uploadImagefileWithHttpInfo(uuid, image);
    }

    public ApiResponse<Void> uploadImagefileWithHttpInfo(String uuid, byte[] image) throws ApiException {
        Call call = this.uploadImagefileCall(uuid, image, null, null);
        return this.apiClient.execute(call);
    }

    public Call uploadImagefileAsync(String uuid, byte[] image, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadImagefileCall(uuid, image, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

