/*
 * Decompiled with CFR 0.152.
 */
package nutanix.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import nutanix.ApiCallback;
import nutanix.ApiClient;
import nutanix.ApiException;
import nutanix.ApiResponse;
import nutanix.Configuration;
import nutanix.Pair;
import nutanix.ProgressRequestBody;
import nutanix.ProgressResponseBody;
import nutanix.model.IdempotenceIdentifiersInput;
import nutanix.model.IdempotenceIdentifiersResponse;

public class IdempotenceidentifiersApi {
    private ApiClient apiClient;

    public IdempotenceidentifiersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdempotenceidentifiersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createIdempotenceIdentifierCall(IdempotenceIdentifiersInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        IdempotenceIdentifiersInput localVarPostBody = body;
        String localVarPath = "/idempotence_identifiers".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public IdempotenceIdentifiersResponse createIdempotenceIdentifier(IdempotenceIdentifiersInput body) throws ApiException {
        ApiResponse<IdempotenceIdentifiersResponse> resp = this.createIdempotenceIdentifierWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<IdempotenceIdentifiersResponse> createIdempotenceIdentifierWithHttpInfo(IdempotenceIdentifiersInput body) throws ApiException {
        Call call = this.createIdempotenceIdentifierCall(body, null, null);
        Type localVarReturnType = new TypeToken<IdempotenceIdentifiersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createIdempotenceIdentifierAsync(IdempotenceIdentifiersInput body, final ApiCallback<IdempotenceIdentifiersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createIdempotenceIdentifierCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdempotenceIdentifiersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteIdempotenceIdentifierclientIdentifierCall(String clientIdentifier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (clientIdentifier == null) {
            throw new ApiException("Missing the required parameter 'clientIdentifier' when calling deleteIdempotenceIdentifierclientIdentifier(Async)");
        }
        String localVarPath = "/idempotence_identifiers/{client_identifier}".replaceAll("\\{format\\}", "json").replaceAll("\\{client_identifier\\}", this.apiClient.escapeString(clientIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteIdempotenceIdentifierclientIdentifier(String clientIdentifier) throws ApiException {
        this.deleteIdempotenceIdentifierclientIdentifierWithHttpInfo(clientIdentifier);
    }

    public ApiResponse<Void> deleteIdempotenceIdentifierclientIdentifierWithHttpInfo(String clientIdentifier) throws ApiException {
        Call call = this.deleteIdempotenceIdentifierclientIdentifierCall(clientIdentifier, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteIdempotenceIdentifierclientIdentifierAsync(String clientIdentifier, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteIdempotenceIdentifierclientIdentifierCall(clientIdentifier, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getIdempotenceIdentifierclientIdentifierCall(String clientIdentifier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (clientIdentifier == null) {
            throw new ApiException("Missing the required parameter 'clientIdentifier' when calling getIdempotenceIdentifierclientIdentifier(Async)");
        }
        String localVarPath = "/idempotence_identifiers/{client_identifier}".replaceAll("\\{format\\}", "json").replaceAll("\\{client_identifier\\}", this.apiClient.escapeString(clientIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public IdempotenceIdentifiersResponse getIdempotenceIdentifierclientIdentifier(String clientIdentifier) throws ApiException {
        ApiResponse<IdempotenceIdentifiersResponse> resp = this.getIdempotenceIdentifierclientIdentifierWithHttpInfo(clientIdentifier);
        return resp.getData();
    }

    public ApiResponse<IdempotenceIdentifiersResponse> getIdempotenceIdentifierclientIdentifierWithHttpInfo(String clientIdentifier) throws ApiException {
        Call call = this.getIdempotenceIdentifierclientIdentifierCall(clientIdentifier, null, null);
        Type localVarReturnType = new TypeToken<IdempotenceIdentifiersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIdempotenceIdentifierclientIdentifierAsync(String clientIdentifier, final ApiCallback<IdempotenceIdentifiersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIdempotenceIdentifierclientIdentifierCall(clientIdentifier, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IdempotenceIdentifiersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

