/*
 * Decompiled with CFR 0.152.
 */
package nutanix.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import nutanix.ApiCallback;
import nutanix.ApiClient;
import nutanix.ApiException;
import nutanix.ApiResponse;
import nutanix.Configuration;
import nutanix.Pair;
import nutanix.ProgressRequestBody;
import nutanix.ProgressResponseBody;
import nutanix.model.DockerRegistryImageSearchListIntentResponse;
import nutanix.model.DockerRegistryIntentInput;
import nutanix.model.DockerRegistryIntentResponse;
import nutanix.model.DockerRegistryListIntentResponse;
import nutanix.model.DockerRegistryListMetadata;

public class DockerregistryApi {
    private ApiClient apiClient;

    public DockerregistryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DockerregistryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createDockerRegistrieCall(DockerRegistryIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DockerRegistryIntentInput localVarPostBody = body;
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDockerRegistrie(Async)");
        }
        String localVarPath = "/docker_registries".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public DockerRegistryIntentResponse createDockerRegistrie(DockerRegistryIntentInput body) throws ApiException {
        ApiResponse<DockerRegistryIntentResponse> resp = this.createDockerRegistrieWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<DockerRegistryIntentResponse> createDockerRegistrieWithHttpInfo(DockerRegistryIntentInput body) throws ApiException {
        Call call = this.createDockerRegistrieCall(body, null, null);
        Type localVarReturnType = new TypeToken<DockerRegistryIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createDockerRegistrieAsync(DockerRegistryIntentInput body, final ApiCallback<DockerRegistryIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createDockerRegistrieCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DockerRegistryIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteDockerRegistrieCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteDockerRegistrie(Async)");
        }
        String localVarPath = "/docker_registries/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteDockerRegistrie(String uuid) throws ApiException {
        this.deleteDockerRegistrieWithHttpInfo(uuid);
    }

    public ApiResponse<Void> deleteDockerRegistrieWithHttpInfo(String uuid) throws ApiException {
        Call call = this.deleteDockerRegistrieCall(uuid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteDockerRegistrieAsync(String uuid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteDockerRegistrieCall(uuid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getDockerRegistrieCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getDockerRegistrie(Async)");
        }
        String localVarPath = "/docker_registries/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public DockerRegistryIntentResponse getDockerRegistrie(String uuid) throws ApiException {
        ApiResponse<DockerRegistryIntentResponse> resp = this.getDockerRegistrieWithHttpInfo(uuid);
        return resp.getData();
    }

    public ApiResponse<DockerRegistryIntentResponse> getDockerRegistrieWithHttpInfo(String uuid) throws ApiException {
        Call call = this.getDockerRegistrieCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<DockerRegistryIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDockerRegistrieAsync(String uuid, final ApiCallback<DockerRegistryIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDockerRegistrieCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DockerRegistryIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call listDockerRegistrieCall(DockerRegistryListMetadata getEntitiesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DockerRegistryListMetadata localVarPostBody = getEntitiesRequest;
        if (getEntitiesRequest == null) {
            throw new ApiException("Missing the required parameter 'getEntitiesRequest' when calling listDockerRegistrie(Async)");
        }
        String localVarPath = "/docker_registries/list".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public DockerRegistryListIntentResponse listDockerRegistrie(DockerRegistryListMetadata getEntitiesRequest) throws ApiException {
        ApiResponse<DockerRegistryListIntentResponse> resp = this.listDockerRegistrieWithHttpInfo(getEntitiesRequest);
        return resp.getData();
    }

    public ApiResponse<DockerRegistryListIntentResponse> listDockerRegistrieWithHttpInfo(DockerRegistryListMetadata getEntitiesRequest) throws ApiException {
        Call call = this.listDockerRegistrieCall(getEntitiesRequest, null, null);
        Type localVarReturnType = new TypeToken<DockerRegistryListIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listDockerRegistrieAsync(DockerRegistryListMetadata getEntitiesRequest, final ApiCallback<DockerRegistryListIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listDockerRegistrieCall(getEntitiesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DockerRegistryListIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call listDockerRegistriesearchCall(String uuid, DockerRegistryListMetadata getEntitiesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DockerRegistryListMetadata localVarPostBody = getEntitiesRequest;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling listDockerRegistriesearch(Async)");
        }
        if (getEntitiesRequest == null) {
            throw new ApiException("Missing the required parameter 'getEntitiesRequest' when calling listDockerRegistriesearch(Async)");
        }
        String localVarPath = "/docker_registries/{uuid}/search/list".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public DockerRegistryImageSearchListIntentResponse listDockerRegistriesearch(String uuid, DockerRegistryListMetadata getEntitiesRequest) throws ApiException {
        ApiResponse<DockerRegistryImageSearchListIntentResponse> resp = this.listDockerRegistriesearchWithHttpInfo(uuid, getEntitiesRequest);
        return resp.getData();
    }

    public ApiResponse<DockerRegistryImageSearchListIntentResponse> listDockerRegistriesearchWithHttpInfo(String uuid, DockerRegistryListMetadata getEntitiesRequest) throws ApiException {
        Call call = this.listDockerRegistriesearchCall(uuid, getEntitiesRequest, null, null);
        Type localVarReturnType = new TypeToken<DockerRegistryImageSearchListIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listDockerRegistriesearchAsync(String uuid, DockerRegistryListMetadata getEntitiesRequest, final ApiCallback<DockerRegistryImageSearchListIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listDockerRegistriesearchCall(uuid, getEntitiesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DockerRegistryImageSearchListIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateDockerRegistrieCall(String uuid, DockerRegistryIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DockerRegistryIntentInput localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateDockerRegistrie(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateDockerRegistrie(Async)");
        }
        String localVarPath = "/docker_registries/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public DockerRegistryIntentResponse updateDockerRegistrie(String uuid, DockerRegistryIntentInput body) throws ApiException {
        ApiResponse<DockerRegistryIntentResponse> resp = this.updateDockerRegistrieWithHttpInfo(uuid, body);
        return resp.getData();
    }

    public ApiResponse<DockerRegistryIntentResponse> updateDockerRegistrieWithHttpInfo(String uuid, DockerRegistryIntentInput body) throws ApiException {
        Call call = this.updateDockerRegistrieCall(uuid, body, null, null);
        Type localVarReturnType = new TypeToken<DockerRegistryIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateDockerRegistrieAsync(String uuid, DockerRegistryIntentInput body, final ApiCallback<DockerRegistryIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateDockerRegistrieCall(uuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DockerRegistryIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

