/*
 * Decompiled with CFR 0.152.
 */
package nutanix.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import nutanix.ApiCallback;
import nutanix.ApiClient;
import nutanix.ApiException;
import nutanix.ApiResponse;
import nutanix.Configuration;
import nutanix.Pair;
import nutanix.ProgressRequestBody;
import nutanix.ProgressResponseBody;
import nutanix.model.CaCert;
import nutanix.model.CaChainSpec;
import nutanix.model.Certificate;
import nutanix.model.CertificateSpecUploadInput;
import nutanix.model.CloudCredentialsIntentInput;
import nutanix.model.CloudCredentialsIntentResponse;
import nutanix.model.CloudCredentialsListIntentResponse;
import nutanix.model.CloudCredentialsListMetadata;
import nutanix.model.ClusterIntentInput;
import nutanix.model.ClusterIntentResponse;
import nutanix.model.ClusterListIntentResponse;
import nutanix.model.ClusterListMetadata;
import nutanix.model.CsrsSpec;
import nutanix.model.PemkeySpec;

public class ClustersApi {
    private ApiClient apiClient;

    public ClustersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ClustersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createClustercertificatescaCertsCall(String uuid, CaCert spec, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CaCert localVarPostBody = spec;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling createClustercertificatescaCerts(Async)");
        }
        if (spec == null) {
            throw new ApiException("Missing the required parameter 'spec' when calling createClustercertificatescaCerts(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/ca_certs".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void createClustercertificatescaCerts(String uuid, CaCert spec) throws ApiException {
        this.createClustercertificatescaCertsWithHttpInfo(uuid, spec);
    }

    public ApiResponse<Void> createClustercertificatescaCertsWithHttpInfo(String uuid, CaCert spec) throws ApiException {
        Call call = this.createClustercertificatescaCertsCall(uuid, spec, null, null);
        return this.apiClient.execute(call);
    }

    public Call createClustercertificatescaCertsAsync(String uuid, CaCert spec, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createClustercertificatescaCertsCall(uuid, spec, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call createClustercertificatesclientAuthCall(String uuid, CaChainSpec spec, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CaChainSpec localVarPostBody = spec;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling createClustercertificatesclientAuth(Async)");
        }
        if (spec == null) {
            throw new ApiException("Missing the required parameter 'spec' when calling createClustercertificatesclientAuth(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/client_auth".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void createClustercertificatesclientAuth(String uuid, CaChainSpec spec) throws ApiException {
        this.createClustercertificatesclientAuthWithHttpInfo(uuid, spec);
    }

    public ApiResponse<Void> createClustercertificatesclientAuthWithHttpInfo(String uuid, CaChainSpec spec) throws ApiException {
        Call call = this.createClustercertificatesclientAuthCall(uuid, spec, null, null);
        return this.apiClient.execute(call);
    }

    public Call createClustercertificatesclientAuthAsync(String uuid, CaChainSpec spec, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createClustercertificatesclientAuthCall(uuid, spec, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call createClustercertificatespemkeyCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling createClustercertificatespemkey(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/pemkey".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void createClustercertificatespemkey(String uuid) throws ApiException {
        this.createClustercertificatespemkeyWithHttpInfo(uuid);
    }

    public ApiResponse<Void> createClustercertificatespemkeyWithHttpInfo(String uuid) throws ApiException {
        Call call = this.createClustercertificatespemkeyCall(uuid, null, null);
        return this.apiClient.execute(call);
    }

    public Call createClustercertificatespemkeyAsync(String uuid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createClustercertificatespemkeyCall(uuid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call createClustercertificatespemkeyimportCall(String uuid, PemkeySpec spec, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PemkeySpec localVarPostBody = spec;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling createClustercertificatespemkeyimport(Async)");
        }
        if (spec == null) {
            throw new ApiException("Missing the required parameter 'spec' when calling createClustercertificatespemkeyimport(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/pemkey/import".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void createClustercertificatespemkeyimport(String uuid, PemkeySpec spec) throws ApiException {
        this.createClustercertificatespemkeyimportWithHttpInfo(uuid, spec);
    }

    public ApiResponse<Void> createClustercertificatespemkeyimportWithHttpInfo(String uuid, PemkeySpec spec) throws ApiException {
        Call call = this.createClustercertificatespemkeyimportCall(uuid, spec, null, null);
        return this.apiClient.execute(call);
    }

    public Call createClustercertificatespemkeyimportAsync(String uuid, PemkeySpec spec, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createClustercertificatespemkeyimportCall(uuid, spec, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call createClustercertificatessvmCertskmsUuidCall(String uuid, String kmsUuid, CertificateSpecUploadInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CertificateSpecUploadInput localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling createClustercertificatessvmCertskmsUuid(Async)");
        }
        if (kmsUuid == null) {
            throw new ApiException("Missing the required parameter 'kmsUuid' when calling createClustercertificatessvmCertskmsUuid(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createClustercertificatessvmCertskmsUuid(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/svm_certs/{kms_uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{kms_uuid\\}", this.apiClient.escapeString(kmsUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void createClustercertificatessvmCertskmsUuid(String uuid, String kmsUuid, CertificateSpecUploadInput body) throws ApiException {
        this.createClustercertificatessvmCertskmsUuidWithHttpInfo(uuid, kmsUuid, body);
    }

    public ApiResponse<Void> createClustercertificatessvmCertskmsUuidWithHttpInfo(String uuid, String kmsUuid, CertificateSpecUploadInput body) throws ApiException {
        Call call = this.createClustercertificatessvmCertskmsUuidCall(uuid, kmsUuid, body, null, null);
        return this.apiClient.execute(call);
    }

    public Call createClustercertificatessvmCertskmsUuidAsync(String uuid, String kmsUuid, CertificateSpecUploadInput body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createClustercertificatessvmCertskmsUuidCall(uuid, kmsUuid, body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call createClustercloudCredentialscloudTypeCall(String uuid, String cloudType, CloudCredentialsIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CloudCredentialsIntentInput localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling createClustercloudCredentialscloudType(Async)");
        }
        if (cloudType == null) {
            throw new ApiException("Missing the required parameter 'cloudType' when calling createClustercloudCredentialscloudType(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createClustercloudCredentialscloudType(Async)");
        }
        String localVarPath = "/clusters/{uuid}/cloud_credentials/{cloud_type}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{cloud_type\\}", this.apiClient.escapeString(cloudType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public CloudCredentialsIntentResponse createClustercloudCredentialscloudType(String uuid, String cloudType, CloudCredentialsIntentInput body) throws ApiException {
        ApiResponse<CloudCredentialsIntentResponse> resp = this.createClustercloudCredentialscloudTypeWithHttpInfo(uuid, cloudType, body);
        return resp.getData();
    }

    public ApiResponse<CloudCredentialsIntentResponse> createClustercloudCredentialscloudTypeWithHttpInfo(String uuid, String cloudType, CloudCredentialsIntentInput body) throws ApiException {
        Call call = this.createClustercloudCredentialscloudTypeCall(uuid, cloudType, body, null, null);
        Type localVarReturnType = new TypeToken<CloudCredentialsIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createClustercloudCredentialscloudTypeAsync(String uuid, String cloudType, CloudCredentialsIntentInput body, final ApiCallback<CloudCredentialsIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createClustercloudCredentialscloudTypeCall(uuid, cloudType, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CloudCredentialsIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteClustercertificatescaCertscaNameCall(String uuid, String caName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteClustercertificatescaCertscaName(Async)");
        }
        if (caName == null) {
            throw new ApiException("Missing the required parameter 'caName' when calling deleteClustercertificatescaCertscaName(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/ca_certs/{ca_name}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{ca_name\\}", this.apiClient.escapeString(caName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteClustercertificatescaCertscaName(String uuid, String caName) throws ApiException {
        this.deleteClustercertificatescaCertscaNameWithHttpInfo(uuid, caName);
    }

    public ApiResponse<Void> deleteClustercertificatescaCertscaNameWithHttpInfo(String uuid, String caName) throws ApiException {
        Call call = this.deleteClustercertificatescaCertscaNameCall(uuid, caName, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteClustercertificatescaCertscaNameAsync(String uuid, String caName, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteClustercertificatescaCertscaNameCall(uuid, caName, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call deleteClustercertificatesclientAuthCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteClustercertificatesclientAuth(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/client_auth".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteClustercertificatesclientAuth(String uuid) throws ApiException {
        this.deleteClustercertificatesclientAuthWithHttpInfo(uuid);
    }

    public ApiResponse<Void> deleteClustercertificatesclientAuthWithHttpInfo(String uuid) throws ApiException {
        Call call = this.deleteClustercertificatesclientAuthCall(uuid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteClustercertificatesclientAuthAsync(String uuid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteClustercertificatesclientAuthCall(uuid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call deleteClustercertificatessvmCertsnodeUuidkmsUuidCall(String uuid, String nodeUuid, String kmsUuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteClustercertificatessvmCertsnodeUuidkmsUuid(Async)");
        }
        if (nodeUuid == null) {
            throw new ApiException("Missing the required parameter 'nodeUuid' when calling deleteClustercertificatessvmCertsnodeUuidkmsUuid(Async)");
        }
        if (kmsUuid == null) {
            throw new ApiException("Missing the required parameter 'kmsUuid' when calling deleteClustercertificatessvmCertsnodeUuidkmsUuid(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/svm_certs/{node_uuid}/{kms_uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{node_uuid\\}", this.apiClient.escapeString(nodeUuid.toString())).replaceAll("\\{kms_uuid\\}", this.apiClient.escapeString(kmsUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteClustercertificatessvmCertsnodeUuidkmsUuid(String uuid, String nodeUuid, String kmsUuid) throws ApiException {
        this.deleteClustercertificatessvmCertsnodeUuidkmsUuidWithHttpInfo(uuid, nodeUuid, kmsUuid);
    }

    public ApiResponse<Void> deleteClustercertificatessvmCertsnodeUuidkmsUuidWithHttpInfo(String uuid, String nodeUuid, String kmsUuid) throws ApiException {
        Call call = this.deleteClustercertificatessvmCertsnodeUuidkmsUuidCall(uuid, nodeUuid, kmsUuid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteClustercertificatessvmCertsnodeUuidkmsUuidAsync(String uuid, String nodeUuid, String kmsUuid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteClustercertificatessvmCertsnodeUuidkmsUuidCall(uuid, nodeUuid, kmsUuid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call deleteClustercloudCredentialscloudTypeCall(String uuid, String cloudType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteClustercloudCredentialscloudType(Async)");
        }
        if (cloudType == null) {
            throw new ApiException("Missing the required parameter 'cloudType' when calling deleteClustercloudCredentialscloudType(Async)");
        }
        String localVarPath = "/clusters/{uuid}/cloud_credentials/{cloud_type}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{cloud_type\\}", this.apiClient.escapeString(cloudType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteClustercloudCredentialscloudType(String uuid, String cloudType) throws ApiException {
        this.deleteClustercloudCredentialscloudTypeWithHttpInfo(uuid, cloudType);
    }

    public ApiResponse<Void> deleteClustercloudCredentialscloudTypeWithHttpInfo(String uuid, String cloudType) throws ApiException {
        Call call = this.deleteClustercloudCredentialscloudTypeCall(uuid, cloudType, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteClustercloudCredentialscloudTypeAsync(String uuid, String cloudType, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteClustercloudCredentialscloudTypeCall(uuid, cloudType, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call deleteClustercloudCredentialscloudTypecloudCredentialsIdCall(String uuid, String cloudType, Long cloudCredentialsId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling deleteClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        if (cloudType == null) {
            throw new ApiException("Missing the required parameter 'cloudType' when calling deleteClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        if (cloudCredentialsId == null) {
            throw new ApiException("Missing the required parameter 'cloudCredentialsId' when calling deleteClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        String localVarPath = "/clusters/{uuid}/cloud_credentials/{cloud_type}/{cloud_credentials_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{cloud_type\\}", this.apiClient.escapeString(cloudType.toString())).replaceAll("\\{cloud_credentials_id\\}", this.apiClient.escapeString(cloudCredentialsId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void deleteClustercloudCredentialscloudTypecloudCredentialsId(String uuid, String cloudType, Long cloudCredentialsId) throws ApiException {
        this.deleteClustercloudCredentialscloudTypecloudCredentialsIdWithHttpInfo(uuid, cloudType, cloudCredentialsId);
    }

    public ApiResponse<Void> deleteClustercloudCredentialscloudTypecloudCredentialsIdWithHttpInfo(String uuid, String cloudType, Long cloudCredentialsId) throws ApiException {
        Call call = this.deleteClustercloudCredentialscloudTypecloudCredentialsIdCall(uuid, cloudType, cloudCredentialsId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteClustercloudCredentialscloudTypecloudCredentialsIdAsync(String uuid, String cloudType, Long cloudCredentialsId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteClustercloudCredentialscloudTypecloudCredentialsIdCall(uuid, cloudType, cloudCredentialsId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getClusterCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getCluster(Async)");
        }
        String localVarPath = "/clusters/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public ClusterIntentResponse getCluster(String uuid) throws ApiException {
        ApiResponse<ClusterIntentResponse> resp = this.getClusterWithHttpInfo(uuid);
        return resp.getData();
    }

    public ApiResponse<ClusterIntentResponse> getClusterWithHttpInfo(String uuid) throws ApiException {
        Call call = this.getClusterCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<ClusterIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getClusterAsync(String uuid, final ApiCallback<ClusterIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getClusterCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ClusterIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getClustercertificatescsrsCall(String uuid, CsrsSpec body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CsrsSpec localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getClustercertificatescsrs(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getClustercertificatescsrs(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/csrs".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void getClustercertificatescsrs(String uuid, CsrsSpec body) throws ApiException {
        this.getClustercertificatescsrsWithHttpInfo(uuid, body);
    }

    public ApiResponse<Void> getClustercertificatescsrsWithHttpInfo(String uuid, CsrsSpec body) throws ApiException {
        Call call = this.getClustercertificatescsrsCall(uuid, body, null, null);
        return this.apiClient.execute(call);
    }

    public Call getClustercertificatescsrsAsync(String uuid, CsrsSpec body, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getClustercertificatescsrsCall(uuid, body, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getClustercertificatescsrsnodeIpCall(String uuid, String nodeIp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getClustercertificatescsrsnodeIp(Async)");
        }
        if (nodeIp == null) {
            throw new ApiException("Missing the required parameter 'nodeIp' when calling getClustercertificatescsrsnodeIp(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/csrs/{node_ip}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{node_ip\\}", this.apiClient.escapeString(nodeIp.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void getClustercertificatescsrsnodeIp(String uuid, String nodeIp) throws ApiException {
        this.getClustercertificatescsrsnodeIpWithHttpInfo(uuid, nodeIp);
    }

    public ApiResponse<Void> getClustercertificatescsrsnodeIpWithHttpInfo(String uuid, String nodeIp) throws ApiException {
        Call call = this.getClustercertificatescsrsnodeIpCall(uuid, nodeIp, null, null);
        return this.apiClient.execute(call);
    }

    public Call getClustercertificatescsrsnodeIpAsync(String uuid, String nodeIp, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getClustercertificatescsrsnodeIpCall(uuid, nodeIp, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call getClustercloudCredentialscloudTypecloudCredentialsIdCall(String uuid, String cloudType, Long cloudCredentialsId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        if (cloudType == null) {
            throw new ApiException("Missing the required parameter 'cloudType' when calling getClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        if (cloudCredentialsId == null) {
            throw new ApiException("Missing the required parameter 'cloudCredentialsId' when calling getClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        String localVarPath = "/clusters/{uuid}/cloud_credentials/{cloud_type}/{cloud_credentials_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{cloud_type\\}", this.apiClient.escapeString(cloudType.toString())).replaceAll("\\{cloud_credentials_id\\}", this.apiClient.escapeString(cloudCredentialsId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public CloudCredentialsIntentResponse getClustercloudCredentialscloudTypecloudCredentialsId(String uuid, String cloudType, Long cloudCredentialsId) throws ApiException {
        ApiResponse<CloudCredentialsIntentResponse> resp = this.getClustercloudCredentialscloudTypecloudCredentialsIdWithHttpInfo(uuid, cloudType, cloudCredentialsId);
        return resp.getData();
    }

    public ApiResponse<CloudCredentialsIntentResponse> getClustercloudCredentialscloudTypecloudCredentialsIdWithHttpInfo(String uuid, String cloudType, Long cloudCredentialsId) throws ApiException {
        Call call = this.getClustercloudCredentialscloudTypecloudCredentialsIdCall(uuid, cloudType, cloudCredentialsId, null, null);
        Type localVarReturnType = new TypeToken<CloudCredentialsIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getClustercloudCredentialscloudTypecloudCredentialsIdAsync(String uuid, String cloudType, Long cloudCredentialsId, final ApiCallback<CloudCredentialsIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getClustercloudCredentialscloudTypecloudCredentialsIdCall(uuid, cloudType, cloudCredentialsId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CloudCredentialsIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call listClusterCall(ClusterListMetadata getEntitiesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ClusterListMetadata localVarPostBody = getEntitiesRequest;
        if (getEntitiesRequest == null) {
            throw new ApiException("Missing the required parameter 'getEntitiesRequest' when calling listCluster(Async)");
        }
        String localVarPath = "/clusters/list".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public ClusterListIntentResponse listCluster(ClusterListMetadata getEntitiesRequest) throws ApiException {
        ApiResponse<ClusterListIntentResponse> resp = this.listClusterWithHttpInfo(getEntitiesRequest);
        return resp.getData();
    }

    public ApiResponse<ClusterListIntentResponse> listClusterWithHttpInfo(ClusterListMetadata getEntitiesRequest) throws ApiException {
        Call call = this.listClusterCall(getEntitiesRequest, null, null);
        Type localVarReturnType = new TypeToken<ClusterListIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listClusterAsync(ClusterListMetadata getEntitiesRequest, final ApiCallback<ClusterListIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listClusterCall(getEntitiesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ClusterListIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call listClustercloudCredentialscloudTypeCall(String uuid, String cloudType, CloudCredentialsListMetadata getEntitiesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CloudCredentialsListMetadata localVarPostBody = getEntitiesRequest;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling listClustercloudCredentialscloudType(Async)");
        }
        if (cloudType == null) {
            throw new ApiException("Missing the required parameter 'cloudType' when calling listClustercloudCredentialscloudType(Async)");
        }
        if (getEntitiesRequest == null) {
            throw new ApiException("Missing the required parameter 'getEntitiesRequest' when calling listClustercloudCredentialscloudType(Async)");
        }
        String localVarPath = "/clusters/{uuid}/cloud_credentials/{cloud_type}/list".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{cloud_type\\}", this.apiClient.escapeString(cloudType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public CloudCredentialsListIntentResponse listClustercloudCredentialscloudType(String uuid, String cloudType, CloudCredentialsListMetadata getEntitiesRequest) throws ApiException {
        ApiResponse<CloudCredentialsListIntentResponse> resp = this.listClustercloudCredentialscloudTypeWithHttpInfo(uuid, cloudType, getEntitiesRequest);
        return resp.getData();
    }

    public ApiResponse<CloudCredentialsListIntentResponse> listClustercloudCredentialscloudTypeWithHttpInfo(String uuid, String cloudType, CloudCredentialsListMetadata getEntitiesRequest) throws ApiException {
        Call call = this.listClustercloudCredentialscloudTypeCall(uuid, cloudType, getEntitiesRequest, null, null);
        Type localVarReturnType = new TypeToken<CloudCredentialsListIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listClustercloudCredentialscloudTypeAsync(String uuid, String cloudType, CloudCredentialsListMetadata getEntitiesRequest, final ApiCallback<CloudCredentialsListIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listClustercloudCredentialscloudTypeCall(uuid, cloudType, getEntitiesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CloudCredentialsListIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateClusterCall(String uuid, ClusterIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ClusterIntentInput localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateCluster(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateCluster(Async)");
        }
        String localVarPath = "/clusters/{uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public ClusterIntentResponse updateCluster(String uuid, ClusterIntentInput body) throws ApiException {
        ApiResponse<ClusterIntentResponse> resp = this.updateClusterWithHttpInfo(uuid, body);
        return resp.getData();
    }

    public ApiResponse<ClusterIntentResponse> updateClusterWithHttpInfo(String uuid, ClusterIntentInput body) throws ApiException {
        Call call = this.updateClusterCall(uuid, body, null, null);
        Type localVarReturnType = new TypeToken<ClusterIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateClusterAsync(String uuid, ClusterIntentInput body, final ApiCallback<ClusterIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateClusterCall(uuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ClusterIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateClustercertificatesclientAuthCall(String uuid, CaChainSpec spec, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CaChainSpec localVarPostBody = spec;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateClustercertificatesclientAuth(Async)");
        }
        if (spec == null) {
            throw new ApiException("Missing the required parameter 'spec' when calling updateClustercertificatesclientAuth(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/client_auth".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void updateClustercertificatesclientAuth(String uuid, CaChainSpec spec) throws ApiException {
        this.updateClustercertificatesclientAuthWithHttpInfo(uuid, spec);
    }

    public ApiResponse<Void> updateClustercertificatesclientAuthWithHttpInfo(String uuid, CaChainSpec spec) throws ApiException {
        Call call = this.updateClustercertificatesclientAuthCall(uuid, spec, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateClustercertificatesclientAuthAsync(String uuid, CaChainSpec spec, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateClustercertificatesclientAuthCall(uuid, spec, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call updateClustercertificatessvmCertsnodeUuidkmsUuidCall(String uuid, String nodeUuid, String kmsUuid, Certificate cert, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Certificate localVarPostBody = cert;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateClustercertificatessvmCertsnodeUuidkmsUuid(Async)");
        }
        if (nodeUuid == null) {
            throw new ApiException("Missing the required parameter 'nodeUuid' when calling updateClustercertificatessvmCertsnodeUuidkmsUuid(Async)");
        }
        if (kmsUuid == null) {
            throw new ApiException("Missing the required parameter 'kmsUuid' when calling updateClustercertificatessvmCertsnodeUuidkmsUuid(Async)");
        }
        if (cert == null) {
            throw new ApiException("Missing the required parameter 'cert' when calling updateClustercertificatessvmCertsnodeUuidkmsUuid(Async)");
        }
        String localVarPath = "/clusters/{uuid}/certificates/svm_certs/{node_uuid}/{kms_uuid}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{node_uuid\\}", this.apiClient.escapeString(nodeUuid.toString())).replaceAll("\\{kms_uuid\\}", this.apiClient.escapeString(kmsUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public void updateClustercertificatessvmCertsnodeUuidkmsUuid(String uuid, String nodeUuid, String kmsUuid, Certificate cert) throws ApiException {
        this.updateClustercertificatessvmCertsnodeUuidkmsUuidWithHttpInfo(uuid, nodeUuid, kmsUuid, cert);
    }

    public ApiResponse<Void> updateClustercertificatessvmCertsnodeUuidkmsUuidWithHttpInfo(String uuid, String nodeUuid, String kmsUuid, Certificate cert) throws ApiException {
        Call call = this.updateClustercertificatessvmCertsnodeUuidkmsUuidCall(uuid, nodeUuid, kmsUuid, cert, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateClustercertificatessvmCertsnodeUuidkmsUuidAsync(String uuid, String nodeUuid, String kmsUuid, Certificate cert, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateClustercertificatessvmCertsnodeUuidkmsUuidCall(uuid, nodeUuid, kmsUuid, cert, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call updateClustercloudCredentialscloudTypecloudCredentialsIdCall(String uuid, String cloudType, Long cloudCredentialsId, CloudCredentialsIntentInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CloudCredentialsIntentInput localVarPostBody = body;
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        if (cloudType == null) {
            throw new ApiException("Missing the required parameter 'cloudType' when calling updateClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        if (cloudCredentialsId == null) {
            throw new ApiException("Missing the required parameter 'cloudCredentialsId' when calling updateClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateClustercloudCredentialscloudTypecloudCredentialsId(Async)");
        }
        String localVarPath = "/clusters/{uuid}/cloud_credentials/{cloud_type}/{cloud_credentials_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString())).replaceAll("\\{cloud_type\\}", this.apiClient.escapeString(cloudType.toString())).replaceAll("\\{cloud_credentials_id\\}", this.apiClient.escapeString(cloudCredentialsId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public CloudCredentialsIntentResponse updateClustercloudCredentialscloudTypecloudCredentialsId(String uuid, String cloudType, Long cloudCredentialsId, CloudCredentialsIntentInput body) throws ApiException {
        ApiResponse<CloudCredentialsIntentResponse> resp = this.updateClustercloudCredentialscloudTypecloudCredentialsIdWithHttpInfo(uuid, cloudType, cloudCredentialsId, body);
        return resp.getData();
    }

    public ApiResponse<CloudCredentialsIntentResponse> updateClustercloudCredentialscloudTypecloudCredentialsIdWithHttpInfo(String uuid, String cloudType, Long cloudCredentialsId, CloudCredentialsIntentInput body) throws ApiException {
        Call call = this.updateClustercloudCredentialscloudTypecloudCredentialsIdCall(uuid, cloudType, cloudCredentialsId, body, null, null);
        Type localVarReturnType = new TypeToken<CloudCredentialsIntentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateClustercloudCredentialscloudTypecloudCredentialsIdAsync(String uuid, String cloudType, Long cloudCredentialsId, CloudCredentialsIntentInput body, final ApiCallback<CloudCredentialsIntentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateClustercloudCredentialscloudTypecloudCredentialsIdCall(uuid, cloudType, cloudCredentialsId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CloudCredentialsIntentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

