/*
 * Decompiled with CFR 0.152.
 */
package nutanix.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import nutanix.ApiCallback;
import nutanix.ApiClient;
import nutanix.ApiException;
import nutanix.ApiResponse;
import nutanix.Configuration;
import nutanix.Pair;
import nutanix.ProgressRequestBody;
import nutanix.ProgressResponseBody;
import nutanix.model.BatchRequest;
import nutanix.model.BatchResponse;

public class BatchApi {
    private ApiClient apiClient;

    public BatchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BatchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createBatchCall(BatchRequest intentList, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BatchRequest localVarPostBody = intentList;
        if (intentList == null) {
            throw new ApiException("Missing the required parameter 'intentList' when calling createBatch(Async)");
        }
        String localVarPath = "/batch".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public BatchResponse createBatch(BatchRequest intentList) throws ApiException {
        ApiResponse<BatchResponse> resp = this.createBatchWithHttpInfo(intentList);
        return resp.getData();
    }

    public ApiResponse<BatchResponse> createBatchWithHttpInfo(BatchRequest intentList) throws ApiException {
        Call call = this.createBatchCall(intentList, null, null);
        Type localVarReturnType = new TypeToken<BatchResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createBatchAsync(BatchRequest intentList, final ApiCallback<BatchResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createBatchCall(intentList, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BatchResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

