/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.AFDOriginGroupUpdateParameters;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.implementation.AFDOriginGroupInner;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.UsageInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AFDOriginGroupsInner {
    private AFDOriginGroupsService service;
    private CdnManagementClientImpl client;

    public AFDOriginGroupsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (AFDOriginGroupsService)retrofit.create(AFDOriginGroupsService.class);
        this.client = client;
    }

    public PagedList<AFDOriginGroupInner> listByProfile(String resourceGroupName, String profileName) {
        ServiceResponse response = (ServiceResponse)this.listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<AFDOriginGroupInner>((Page)response.body()){

            public Page<AFDOriginGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDOriginGroupsInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AFDOriginGroupInner>> listByProfileAsync(String resourceGroupName, String profileName, ListOperationCallback<AFDOriginGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileSinglePageAsync(resourceGroupName, profileName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AFDOriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> call(String nextPageLink) {
                return AFDOriginGroupsInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AFDOriginGroupInner>> listByProfileAsync(String resourceGroupName, String profileName) {
        return this.listByProfileWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Page<AFDOriginGroupInner>>, Page<AFDOriginGroupInner>>(){

            public Page<AFDOriginGroupInner> call(ServiceResponse<Page<AFDOriginGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> listByProfileWithServiceResponseAsync(String resourceGroupName, String profileName) {
        return this.listByProfileSinglePageAsync(resourceGroupName, profileName).concatMap((Func1)new Func1<ServiceResponse<Page<AFDOriginGroupInner>>, Observable<ServiceResponse<Page<AFDOriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> call(ServiceResponse<Page<AFDOriginGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDOriginGroupsInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDOriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDOriginGroupsInner.this.listByProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AFDOriginGroupInner>> listByProfileDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AFDOriginGroupInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDOriginGroupInner get(String resourceGroupName, String profileName, String originGroupName) {
        return (AFDOriginGroupInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<AFDOriginGroupInner> getAsync(String resourceGroupName, String profileName, String originGroupName, ServiceCallback<AFDOriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName), serviceCallback);
    }

    public Observable<AFDOriginGroupInner> getAsync(String resourceGroupName, String profileName, String originGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName).map((Func1)new Func1<ServiceResponse<AFDOriginGroupInner>, AFDOriginGroupInner>(){

            public AFDOriginGroupInner call(ServiceResponse<AFDOriginGroupInner> response) {
                return (AFDOriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginGroupInner>>>(){

            public Observable<ServiceResponse<AFDOriginGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDOriginGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDOriginGroupInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDOriginGroupInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDOriginGroupInner create(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupInner originGroup) {
        return (AFDOriginGroupInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroup).toBlocking().last()).body());
    }

    public ServiceFuture<AFDOriginGroupInner> createAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupInner originGroup, ServiceCallback<AFDOriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroup), serviceCallback);
    }

    public Observable<AFDOriginGroupInner> createAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupInner originGroup) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroup).map((Func1)new Func1<ServiceResponse<AFDOriginGroupInner>, AFDOriginGroupInner>(){

            public AFDOriginGroupInner call(ServiceResponse<AFDOriginGroupInner> response) {
                return (AFDOriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginGroupInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupInner originGroup) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroup == null) {
            throw new IllegalArgumentException("Parameter originGroup is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)originGroup));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), originGroup, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDOriginGroupInner>(){}.getType());
    }

    public AFDOriginGroupInner beginCreate(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupInner originGroup) {
        return (AFDOriginGroupInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroup).toBlocking().single()).body());
    }

    public ServiceFuture<AFDOriginGroupInner> beginCreateAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupInner originGroup, ServiceCallback<AFDOriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroup), serviceCallback);
    }

    public Observable<AFDOriginGroupInner> beginCreateAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupInner originGroup) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroup).map((Func1)new Func1<ServiceResponse<AFDOriginGroupInner>, AFDOriginGroupInner>(){

            public AFDOriginGroupInner call(ServiceResponse<AFDOriginGroupInner> response) {
                return (AFDOriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginGroupInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupInner originGroup) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroup == null) {
            throw new IllegalArgumentException("Parameter originGroup is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)originGroup));
        return this.service.beginCreate(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), originGroup, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginGroupInner>>>(){

            public Observable<ServiceResponse<AFDOriginGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDOriginGroupsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDOriginGroupInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDOriginGroupInner>(){}.getType()).register(201, new TypeToken<AFDOriginGroupInner>(){}.getType()).register(202, new TypeToken<AFDOriginGroupInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDOriginGroupInner update(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupUpdateParameters originGroupUpdateProperties) {
        return (AFDOriginGroupInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties).toBlocking().last()).body());
    }

    public ServiceFuture<AFDOriginGroupInner> updateAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupUpdateParameters originGroupUpdateProperties, ServiceCallback<AFDOriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties), serviceCallback);
    }

    public Observable<AFDOriginGroupInner> updateAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupUpdateParameters originGroupUpdateProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties).map((Func1)new Func1<ServiceResponse<AFDOriginGroupInner>, AFDOriginGroupInner>(){

            public AFDOriginGroupInner call(ServiceResponse<AFDOriginGroupInner> response) {
                return (AFDOriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupUpdateParameters originGroupUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroupUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)originGroupUpdateProperties);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), originGroupUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDOriginGroupInner>(){}.getType());
    }

    public AFDOriginGroupInner beginUpdate(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupUpdateParameters originGroupUpdateProperties) {
        return (AFDOriginGroupInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties).toBlocking().single()).body());
    }

    public ServiceFuture<AFDOriginGroupInner> beginUpdateAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupUpdateParameters originGroupUpdateProperties, ServiceCallback<AFDOriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties), serviceCallback);
    }

    public Observable<AFDOriginGroupInner> beginUpdateAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupUpdateParameters originGroupUpdateProperties) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties).map((Func1)new Func1<ServiceResponse<AFDOriginGroupInner>, AFDOriginGroupInner>(){

            public AFDOriginGroupInner call(ServiceResponse<AFDOriginGroupInner> response) {
                return (AFDOriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginGroupInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, AFDOriginGroupUpdateParameters originGroupUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroupUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)originGroupUpdateProperties);
        return this.service.beginUpdate(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), originGroupUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginGroupInner>>>(){

            public Observable<ServiceResponse<AFDOriginGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDOriginGroupsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDOriginGroupInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDOriginGroupInner>(){}.getType()).register(202, new TypeToken<AFDOriginGroupInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String originGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String originGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String originGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String originGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDOriginGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<UsageInner> listResourceUsage(String resourceGroupName, String profileName, String originGroupName) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, originGroupName).toBlocking().single();
        return new PagedList<UsageInner>((Page)response.body()){

            public Page<UsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDOriginGroupsInner.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UsageInner>> listResourceUsageAsync(String resourceGroupName, String profileName, String originGroupName, ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, originGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                return AFDOriginGroupsInner.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UsageInner>> listResourceUsageAsync(String resourceGroupName, String profileName, String originGroupName) {
        return this.listResourceUsageWithServiceResponseAsync(resourceGroupName, profileName, originGroupName).map((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>(){

            public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName) {
        return this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, originGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDOriginGroupsInner.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listResourceUsage(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDOriginGroupsInner.this.listResourceUsageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listResourceUsageDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<AFDOriginGroupInner> listByProfileNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AFDOriginGroupInner>((Page)response.body()){

            public Page<AFDOriginGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDOriginGroupsInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AFDOriginGroupInner>> listByProfileNextAsync(String nextPageLink, ServiceFuture<List<AFDOriginGroupInner>> serviceFuture, ListOperationCallback<AFDOriginGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AFDOriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> call(String nextPageLink) {
                return AFDOriginGroupsInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AFDOriginGroupInner>> listByProfileNextAsync(String nextPageLink) {
        return this.listByProfileNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AFDOriginGroupInner>>, Page<AFDOriginGroupInner>>(){

            public Page<AFDOriginGroupInner> call(ServiceResponse<Page<AFDOriginGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> listByProfileNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByProfileNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AFDOriginGroupInner>>, Observable<ServiceResponse<Page<AFDOriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> call(ServiceResponse<Page<AFDOriginGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDOriginGroupsInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> listByProfileNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDOriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDOriginGroupsInner.this.listByProfileNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AFDOriginGroupInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AFDOriginGroupInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<UsageInner> listResourceUsageNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<UsageInner>((Page)response.body()){

            public Page<UsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDOriginGroupsInner.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<UsageInner>> listResourceUsageNextAsync(String nextPageLink, ServiceFuture<List<UsageInner>> serviceFuture, ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                return AFDOriginGroupsInner.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<UsageInner>> listResourceUsageNextAsync(String nextPageLink) {
        return this.listResourceUsageNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>(){

            public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageNextWithServiceResponseAsync(String nextPageLink) {
        return this.listResourceUsageNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDOriginGroupsInner.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listResourceUsageNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>(){

            public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDOriginGroupsInner.this.listResourceUsageNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listResourceUsageNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface AFDOriginGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups listByProfile"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups")
        public Observable<Response<ResponseBody>> listByProfile(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Body AFDOriginGroupInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Body AFDOriginGroupInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Body AFDOriginGroupUpdateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Body AFDOriginGroupUpdateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups listResourceUsage"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/usages")
        public Observable<Response<ResponseBody>> listResourceUsage(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups listByProfileNext"})
        @GET
        public Observable<Response<ResponseBody>> listByProfileNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOriginGroups listResourceUsageNext"})
        @GET
        public Observable<Response<ResponseBody>> listResourceUsageNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

