/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.CycleDetectionStrategy;
import net.sf.json.util.JavaIdentifierTransformer;
import net.sf.json.util.JsonEventListener;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang.StringUtils;

public class JsonConfig {
    private static final CycleDetectionStrategy DEFAULT_CYCLE_DETECTION_STRATEGY = CycleDetectionStrategy.STRICT;
    private static final String[] DEFAULT_EXCLUDES = new String[]{"class", "declaringClass", "metaClass"};
    private static final JavaIdentifierTransformer DEFAULT_JAVA_IDENTIFIER_TRANSFORMER = JavaIdentifierTransformer.NOOP;
    private static final String[] EMPTY_EXCLUDES = new String[0];
    private static JsonConfig instance = new JsonConfig();
    private MultiKeyMap beanKeyMap = new MultiKeyMap();
    private MultiKeyMap beanTypeMap = new MultiKeyMap();
    private CycleDetectionStrategy cycleDetectionStrategy = DEFAULT_CYCLE_DETECTION_STRATEGY;
    private List eventListeners = new ArrayList();
    private String[] excludes = EMPTY_EXCLUDES;
    private boolean ignoreDefaultExcludes;
    private boolean ignoreTransientFields;
    private JavaIdentifierTransformer javaIdentifierTransformer = DEFAULT_JAVA_IDENTIFIER_TRANSFORMER;
    private Map keyMap = new HashMap();
    private Map processorMap = new HashMap();
    private boolean skipJavaIdentifierTransformationInMapKeys;
    private boolean triggerEvents;
    private Map typeMap = new HashMap();

    public static JsonConfig getInstance() {
        return instance;
    }

    private JsonConfig() {
    }

    public synchronized void addJsonEventListener(JsonEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public void clearJsonBeanProcessors() {
        this.processorMap.clear();
    }

    public synchronized void clearJsonEventListeners() {
        this.eventListeners.clear();
    }

    public void clearJsonValueProcessors() {
        this.beanKeyMap.clear();
        this.beanTypeMap.clear();
        this.keyMap.clear();
        this.typeMap.clear();
    }

    public void disableEventTriggering() {
        this.triggerEvents = false;
    }

    public void enableEventTriggering() {
        this.triggerEvents = true;
    }

    public JsonBeanProcessor findJsonBeanProcessor(Class target) {
        if (target != null) {
            return (JsonBeanProcessor)this.processorMap.get(target);
        }
        return null;
    }

    public JsonValueProcessor findJsonValueProcessor(Class propertyType) {
        JsonValueProcessor jsonValueProcessor = null;
        jsonValueProcessor = (JsonValueProcessor)this.typeMap.get(propertyType);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        return null;
    }

    public JsonValueProcessor findJsonValueProcessor(Class beanClass, Class propertyType, String key) {
        JsonValueProcessor jsonValueProcessor = null;
        jsonValueProcessor = (JsonValueProcessor)this.beanKeyMap.get((Object)beanClass, (Object)key);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        jsonValueProcessor = (JsonValueProcessor)this.beanTypeMap.get((Object)beanClass, (Object)propertyType);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        jsonValueProcessor = (JsonValueProcessor)this.keyMap.get(key);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        jsonValueProcessor = (JsonValueProcessor)this.typeMap.get(propertyType);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        return null;
    }

    public JsonValueProcessor findJsonValueProcessor(Class propertyType, String key) {
        JsonValueProcessor jsonValueProcessor = null;
        jsonValueProcessor = (JsonValueProcessor)this.keyMap.get(key);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        jsonValueProcessor = (JsonValueProcessor)this.typeMap.get(propertyType);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        return null;
    }

    public CycleDetectionStrategy getCycleDetectionStrategy() {
        return this.cycleDetectionStrategy;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public JavaIdentifierTransformer getJavaIdentifierTransformer() {
        return this.javaIdentifierTransformer;
    }

    public synchronized List getJsonEventListeners() {
        return this.eventListeners;
    }

    public Collection getMergedExcludes() {
        int i;
        HashSet<String> exclusions = new HashSet<String>();
        for (i = 0; i < this.excludes.length; ++i) {
            String exclusion = this.excludes[i];
            if (StringUtils.isBlank((String)this.excludes[i])) continue;
            exclusions.add(exclusion.trim());
        }
        if (!this.ignoreDefaultExcludes) {
            for (i = 0; i < DEFAULT_EXCLUDES.length; ++i) {
                if (exclusions.contains(DEFAULT_EXCLUDES[i])) continue;
                exclusions.add(DEFAULT_EXCLUDES[i]);
            }
        }
        return exclusions;
    }

    public boolean isEventTriggeringEnabled() {
        return this.triggerEvents;
    }

    public boolean isIgnoreDefaultExcludes() {
        return this.ignoreDefaultExcludes;
    }

    public boolean isIgnoreTransientFields() {
        return this.ignoreTransientFields;
    }

    public boolean isSkipJavaIdentifierTransformationInMapKeys() {
        return this.skipJavaIdentifierTransformationInMapKeys;
    }

    public void registerJsonBeanProcessor(Class target, JsonBeanProcessor jsonBeanProcessor) {
        if (target != null && jsonBeanProcessor != null) {
            this.processorMap.put(target, jsonBeanProcessor);
        }
    }

    public void registerJsonValueProcessor(Class beanClass, Class propertyType, JsonValueProcessor jsonValueProcessor) {
        if (beanClass != null && propertyType != null && jsonValueProcessor != null) {
            this.beanTypeMap.put((Object)beanClass, (Object)propertyType, (Object)jsonValueProcessor);
        }
    }

    public void registerJsonValueProcessor(Class propertyType, JsonValueProcessor jsonValueProcessor) {
        if (propertyType != null && jsonValueProcessor != null) {
            this.typeMap.put(propertyType, jsonValueProcessor);
        }
    }

    public void registerJsonValueProcessor(Class beanClass, String key, JsonValueProcessor jsonValueProcessor) {
        if (beanClass != null && key != null && jsonValueProcessor != null) {
            this.beanKeyMap.put((Object)beanClass, (Object)key, (Object)jsonValueProcessor);
        }
    }

    public void registerJsonValueProcessor(String key, JsonValueProcessor jsonValueProcessor) {
        if (key != null && jsonValueProcessor != null) {
            this.keyMap.put(key, jsonValueProcessor);
        }
    }

    public synchronized void removeJsonEventListener(JsonEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void reset() {
        this.excludes = EMPTY_EXCLUDES;
        this.ignoreDefaultExcludes = false;
        this.ignoreTransientFields = false;
        this.javaIdentifierTransformer = DEFAULT_JAVA_IDENTIFIER_TRANSFORMER;
        this.cycleDetectionStrategy = DEFAULT_CYCLE_DETECTION_STRATEGY;
        this.skipJavaIdentifierTransformationInMapKeys = false;
        this.triggerEvents = false;
    }

    public void setCycleDetectionStrategy(CycleDetectionStrategy cycleDetectionStrategy) {
        this.cycleDetectionStrategy = cycleDetectionStrategy == null ? DEFAULT_CYCLE_DETECTION_STRATEGY : cycleDetectionStrategy;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes == null ? EMPTY_EXCLUDES : excludes;
    }

    public void setIgnoreDefaultExcludes(boolean ignoreDefaultExcludes) {
        this.ignoreDefaultExcludes = ignoreDefaultExcludes;
    }

    public void setIgnoreTransientFields(boolean ignoreTransientFields) {
        this.ignoreTransientFields = ignoreTransientFields;
    }

    public void setJavaIdentifierTransformer(JavaIdentifierTransformer javaIdentifierTransformer) {
        this.javaIdentifierTransformer = javaIdentifierTransformer == null ? DEFAULT_JAVA_IDENTIFIER_TRANSFORMER : javaIdentifierTransformer;
    }

    public void setSkipJavaIdentifierTransformationInMapKeys(boolean skipJavaIdentifierTransformationInMapKeys) {
        this.skipJavaIdentifierTransformationInMapKeys = skipJavaIdentifierTransformationInMapKeys;
    }

    public void unregisterJsonBeanProcessor(Class target) {
        if (target != null) {
            this.processorMap.remove(target);
        }
    }

    public void unregisterJsonValueProcessor(Class propertyType) {
        if (propertyType != null) {
            this.typeMap.remove(propertyType);
        }
    }

    public void unregisterJsonValueProcessor(Class beanClass, Class propertyType) {
        if (beanClass != null && propertyType != null) {
            this.beanTypeMap.remove((Object)beanClass, (Object)propertyType);
        }
    }

    public void unregisterJsonValueProcessor(Class beanClass, String key) {
        if (beanClass != null && key != null) {
            this.beanKeyMap.remove((Object)beanClass, (Object)key);
        }
    }

    public void unregisterJsonValueProcessor(String key) {
        if (key != null) {
            this.keyMap.remove(key);
        }
    }
}

