/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import net.sf.json.AbstractJSON;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JSONString;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonVerifier;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;
import org.apache.commons.lang.StringUtils;

public final class JSONArray
extends AbstractJSON
implements JSON,
List,
Comparable {
    private List elements = new ArrayList();
    private boolean expandElements;

    public static JSONArray fromArray(Object[] array) {
        return JSONArray._fromArray(array);
    }

    public static JSONArray fromCollection(Collection collection) {
        return JSONArray._fromCollection(collection);
    }

    public static JSONArray fromJSONString(JSONString string) {
        return JSONArray._fromJSONString(string);
    }

    public static JSONArray fromObject(Object object) {
        if (object instanceof JSONString) {
            return JSONArray._fromJSONString((JSONString)object);
        }
        if (object instanceof JSONArray) {
            return JSONArray._fromJSONArray((JSONArray)object);
        }
        if (object instanceof Collection) {
            return JSONArray._fromCollection((Collection)object);
        }
        if (object instanceof JSONTokener) {
            return JSONArray._fromJSONTokener((JSONTokener)object);
        }
        if (object instanceof String) {
            return JSONArray._fromString((String)object);
        }
        if (object != null && object.getClass().isArray()) {
            Class<?> type = object.getClass().getComponentType();
            if (!type.isPrimitive()) {
                return JSONArray._fromArray((Object[])object);
            }
            if (type == Boolean.TYPE) {
                return JSONArray._fromArray((boolean[])object);
            }
            if (type == Byte.TYPE) {
                return JSONArray._fromArray((byte[])object);
            }
            if (type == Short.TYPE) {
                return JSONArray._fromArray((short[])object);
            }
            if (type == Integer.TYPE) {
                return JSONArray._fromArray((int[])object);
            }
            if (type == Long.TYPE) {
                return JSONArray._fromArray((long[])object);
            }
            if (type == Float.TYPE) {
                return JSONArray._fromArray((float[])object);
            }
            if (type == Double.TYPE) {
                return JSONArray._fromArray((double[])object);
            }
            if (type == Character.TYPE) {
                return JSONArray._fromArray((char[])object);
            }
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isBoolean(object) || JSONUtils.isFunction(object) || JSONUtils.isNumber(object) || JSONUtils.isNull(object) || JSONUtils.isString(object) || object instanceof JSON) {
            JSONArray.fireArrayStartEvent();
            JSONArray jsonArray = new JSONArray().element(object);
            JSONArray.fireElementAddedEvent(0, jsonArray.get(0));
            JSONArray.fireArrayStartEvent();
            return jsonArray;
        }
        if (object instanceof Enum) {
            return JSONArray._fromArray((Enum)object);
        }
        if (object instanceof Annotation || object != null && object.getClass().isAnnotation()) {
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isObject(object)) {
            JSONArray.fireArrayStartEvent();
            JSONArray jsonArray = new JSONArray().element(JSONObject.fromObject(object));
            JSONArray.fireElementAddedEvent(0, jsonArray.get(0));
            JSONArray.fireArrayStartEvent();
            return jsonArray;
        }
        throw new JSONException("Unsupported type");
    }

    public static JSONArray fromString(String string) {
        return JSONArray._fromString(string);
    }

    public static int[] getDimensions(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return new int[]{0};
        }
        ArrayList dims = new ArrayList();
        JSONArray.processArrayDimensions(jsonArray, dims, 0);
        int[] dimensions = new int[dims.size()];
        int j = 0;
        Iterator i = dims.iterator();
        while (i.hasNext()) {
            dimensions[j++] = (Integer)i.next();
        }
        return dimensions;
    }

    public static Object[] toArray(JSONArray jsonArray) {
        return JSONArray.toArray(jsonArray, null, null);
    }

    public static Object[] toArray(JSONArray jsonArray, Class objectClass) {
        return JSONArray.toArray(jsonArray, objectClass, null);
    }

    public static Object[] toArray(JSONArray jsonArray, Class objectClass, Map classMap) {
        if (jsonArray.size() == 0) {
            return new Object[0];
        }
        int[] dimensions = JSONArray.getDimensions(jsonArray);
        Object array = Array.newInstance(Object.class, dimensions);
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                Array.set(array, i, null);
                continue;
            }
            Class<?> type = value.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                Array.set(array, i, JSONArray.toArray((JSONArray)value, objectClass, classMap));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                Array.set(array, i, value);
                continue;
            }
            if (objectClass != null) {
                Array.set(array, i, JSONObject.toBean((JSONObject)value, objectClass, classMap));
                continue;
            }
            Array.set(array, i, JSONObject.toBean((JSONObject)value));
        }
        return (Object[])array;
    }

    public static List toList(JSONArray jsonArray) {
        return JSONArray.toList(jsonArray, null, null);
    }

    public static List toList(JSONArray jsonArray, Class objectClass) {
        return JSONArray.toList(jsonArray, objectClass, null);
    }

    public static List toList(JSONArray jsonArray, Class objectClass, Map classMap) {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                list.add(null);
                continue;
            }
            Class<?> type = value.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                list.add(JSONArray.toList((JSONArray)value, objectClass, classMap));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                list.add(value);
                continue;
            }
            if (objectClass != null) {
                list.add(JSONObject.toBean((JSONObject)value, objectClass, classMap));
                continue;
            }
            list.add(JSONObject.toBean((JSONObject)value));
        }
        return list;
    }

    private static JSONArray _fromArray(boolean[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Boolean b = array[i] ? Boolean.TRUE : Boolean.FALSE;
            jsonArray.elements.add(b);
            JSONArray.fireElementAddedEvent(i, b);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(byte[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(new Byte(array[i]));
            jsonArray.elements.add(n);
            JSONArray.fireElementAddedEvent(i, n);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(char[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Character c = new Character(array[i]);
            jsonArray.elements.add(c);
            JSONArray.fireElementAddedEvent(i, c);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(double[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                Double d = new Double(array[i]);
                JSONUtils.testValidity(d);
                jsonArray.elements.add(d);
                JSONArray.fireElementAddedEvent(i, d);
            }
        }
        catch (JSONException jsone) {
            JSONArray.removeInstance(array);
            JSONArray.fireErrorEvent(jsone);
            throw jsone;
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(Enum e) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(e)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(e);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException re) {
                JSONArray.removeInstance(e);
                JSONException jsone = new JSONException(re);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        if (e == null) {
            JSONException jsone = new JSONException("enum value is null");
            JSONArray.removeInstance(e);
            JSONArray.fireErrorEvent(jsone);
            throw jsone;
        }
        jsonArray.elements.add(e.toString());
        JSONArray.fireElementAddedEvent(0, jsonArray.get(0));
        JSONArray.removeInstance(e);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(float[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                Float f = new Float(array[i]);
                JSONUtils.testValidity(f);
                jsonArray.elements.add(f);
                JSONArray.fireElementAddedEvent(i, f);
            }
        }
        catch (JSONException jsone) {
            JSONArray.removeInstance(array);
            JSONArray.fireErrorEvent(jsone);
            throw jsone;
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(int[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Integer n = new Integer(array[i]);
            jsonArray.elements.add(n);
            JSONArray.fireElementAddedEvent(i, n);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(long[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(new Long(array[i]));
            jsonArray.elements.add(n);
            JSONArray.fireElementAddedEvent(i, n);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(Object[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                jsonArray.addValue(element);
                JSONArray.fireElementAddedEvent(i, jsonArray.get(i));
            }
        }
        catch (JSONException jsone) {
            JSONArray.removeInstance(array);
            JSONArray.fireErrorEvent(jsone);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONArray.removeInstance(array);
            JSONException jsone = new JSONException(e);
            JSONArray.fireErrorEvent(jsone);
            throw jsone;
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromArray(short[] array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(new Short(array[i]));
            jsonArray.elements.add(n);
            JSONArray.fireElementAddedEvent(i, n);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromCollection(Collection collection) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(collection)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(collection);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(collection);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(collection);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        try {
            int i = 0;
            for (Object element : collection) {
                jsonArray.addValue(element);
                JSONArray.fireElementAddedEvent(i, jsonArray.get(i++));
            }
        }
        catch (JSONException jsone) {
            JSONArray.removeInstance(collection);
            JSONArray.fireErrorEvent(jsone);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONArray.removeInstance(collection);
            JSONException jsone = new JSONException(e);
            JSONArray.fireErrorEvent(jsone);
            throw jsone;
        }
        JSONArray.removeInstance(collection);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromJSONArray(JSONArray array) {
        JsonConfig jsonConfig = JsonConfig.getInstance();
        JSONArray.fireArrayStartEvent();
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone);
                throw jsone;
            }
        }
        JSONArray jsonArray = new JSONArray();
        int index = 0;
        for (Object element : array) {
            jsonArray.elements.add(element);
            JSONArray.fireElementAddedEvent(index++, element);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent();
        return jsonArray;
    }

    private static JSONArray _fromJSONString(JSONString string) {
        return JSONArray._fromJSONTokener(new JSONTokener(string.toJSONString()));
    }

    private static JSONArray _fromJSONTokener(JSONTokener tokener) {
        JSONArray.fireArrayStartEvent();
        JSONArray jsonArray = new JSONArray();
        int index = 0;
        try {
            if (tokener.nextClean() != '[') {
                throw tokener.syntaxError("A JSONArray text must start with '['");
            }
            if (tokener.nextClean() == ']') {
                JSONArray.fireArrayEndEvent();
                return jsonArray;
            }
            tokener.back();
            block6: while (true) {
                if (tokener.nextClean() == ',') {
                    tokener.back();
                    jsonArray.elements.add(JSONNull.getInstance());
                    JSONArray.fireElementAddedEvent(index, jsonArray.get(index++));
                } else {
                    tokener.back();
                    Object v = tokener.nextValue();
                    if (!JSONUtils.isFunctionHeader(v)) {
                        if (v instanceof String && JSONUtils.mayBeJSON((String)v)) {
                            jsonArray.addValue("\"" + v + "\"");
                        } else {
                            jsonArray.addValue(v);
                        }
                        JSONArray.fireElementAddedEvent(index, jsonArray.get(index++));
                    } else {
                        char ch;
                        String params = JSONUtils.getFunctionParams((String)v);
                        int i = 0;
                        StringBuffer sb = new StringBuffer();
                        while ((ch = tokener.next()) != '\u0000') {
                            if (ch == '{') {
                                ++i;
                            }
                            if (ch == '}') {
                                --i;
                            }
                            sb.append(ch);
                            if (i != 0) continue;
                            break;
                        }
                        if (i != 0) {
                            throw tokener.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                        }
                        String text = sb.toString();
                        text = text.substring(1, text.length() - 1).trim();
                        jsonArray.addValue(new JSONFunction(params != null ? StringUtils.split((String)params, (String)",") : null, text));
                        JSONArray.fireElementAddedEvent(index, jsonArray.get(index++));
                    }
                }
                switch (tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == ']') {
                            JSONArray.fireArrayEndEvent();
                            return jsonArray;
                        }
                        tokener.back();
                        continue block6;
                    }
                    case ']': {
                        JSONArray.fireArrayEndEvent();
                        return jsonArray;
                    }
                }
                break;
            }
            throw tokener.syntaxError("Expected a ',' or ']'");
        }
        catch (JSONException jsone) {
            JSONArray.fireErrorEvent(jsone);
            throw jsone;
        }
    }

    private static JSONArray _fromString(String string) {
        return JSONArray._fromJSONTokener(new JSONTokener(string));
    }

    private static void processArrayDimensions(JSONArray jsonArray, List dims, int index) {
        if (dims.size() <= index) {
            dims.add(new Integer(jsonArray.size()));
        } else {
            int i = (Integer)dims.get(index);
            if (jsonArray.size() > i) {
                dims.set(index, new Integer(jsonArray.size()));
            }
        }
        for (Object item : jsonArray) {
            if (!(item instanceof JSONArray)) continue;
            JSONArray.processArrayDimensions((JSONArray)item, dims, index + 1);
        }
    }

    public void add(int index, Object value) {
        this.elements.add(index, this.processValue(value));
    }

    public boolean add(Object value) {
        this.element(value);
        return true;
    }

    public boolean addAll(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.element(i.next());
        }
        return true;
    }

    public boolean addAll(int index, Collection collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        int offset = 0;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.elements.add(index + offset++, this.processValue(i.next()));
        }
        return true;
    }

    public void clear() {
        this.elements.clear();
    }

    public int compareTo(Object obj) {
        if (obj != null && obj instanceof JSONArray) {
            int size2;
            JSONArray other = (JSONArray)obj;
            int size1 = this.size();
            if (size1 < (size2 = other.size())) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            if (this.equals(other)) {
                return 0;
            }
        }
        return -1;
    }

    public boolean contains(Object o) {
        return this.elements.contains(this.processValue(o));
    }

    public boolean containsAll(Collection collection) {
        return this.elements.containsAll(JSONArray.fromObject(collection));
    }

    public JSONArray element(boolean value) {
        return this.element(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONArray element(Collection value) {
        if (value instanceof JSONArray) {
            this.elements.add(value);
            return this;
        }
        return this.element(JSONArray._fromCollection(value));
    }

    public JSONArray element(double value) {
        Double d = new Double(value);
        JSONUtils.testValidity(d);
        return this.element(d);
    }

    public JSONArray element(int value) {
        return this.element(new Integer(value));
    }

    public JSONArray element(int index, boolean value) {
        return this.element(index, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONArray element(int index, Collection value) {
        if (value instanceof JSONArray) {
            if (index < 0) {
                throw new JSONException("JSONArray[" + index + "] not found.");
            }
            if (index < this.size()) {
                this.elements.set(index, value);
            } else {
                while (index != this.size()) {
                    this.element(JSONNull.getInstance());
                }
                this.element(value);
            }
            return this;
        }
        return this.element(index, JSONArray._fromCollection(value));
    }

    public JSONArray element(int index, double value) {
        return this.element(index, new Double(value));
    }

    public JSONArray element(int index, int value) {
        return this.element(index, new Integer(value));
    }

    public JSONArray element(int index, long value) {
        return this.element(index, new Long(value));
    }

    public JSONArray element(int index, Map value) {
        if (value instanceof JSONObject) {
            if (index < 0) {
                throw new JSONException("JSONArray[" + index + "] not found.");
            }
            if (index < this.size()) {
                this.elements.set(index, value);
            } else {
                while (index != this.size()) {
                    this.element(JSONNull.getInstance());
                }
                this.element(value);
            }
            return this;
        }
        return this.element(index, JSONObject.fromObject(value));
    }

    public JSONArray element(int index, Object value) {
        JSONUtils.testValidity(value);
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.size()) {
            this.elements.set(index, this.processValue(value));
        } else {
            while (index != this.size()) {
                this.element(JSONNull.getInstance());
            }
            this.element(value);
        }
        return this;
    }

    public JSONArray element(int index, String value) {
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.size()) {
            if (value == null) {
                this.elements.set(index, "");
            } else if (JSONUtils.mayBeJSON(value)) {
                try {
                    this.elements.set(index, JSONSerializer.toJSON((Object)value));
                }
                catch (JSONException jsone) {
                    this.elements.set(index, JSONUtils.stripQuotes(value));
                }
            } else {
                this.elements.set(index, JSONUtils.stripQuotes(value));
            }
        } else {
            while (index != this.size()) {
                this.element(JSONNull.getInstance());
            }
            this.element(value);
        }
        return this;
    }

    public JSONArray element(JSONNull value) {
        this.elements.add(value);
        return this;
    }

    public JSONArray element(JSONObject value) {
        this.elements.add(value);
        return this;
    }

    public JSONArray element(long value) {
        return this.element(JSONUtils.transformNumber(new Long(value)));
    }

    public JSONArray element(Map value) {
        if (value instanceof JSONObject) {
            this.elements.add(value);
            return this;
        }
        return this.element(JSONObject.fromObject(value));
    }

    public JSONArray element(Object value) {
        return this.addValue(value);
    }

    public JSONArray element(String value) {
        if (value == null) {
            this.elements.add("");
        } else if (JSONUtils.mayBeJSON(value)) {
            try {
                this.elements.add(JSONSerializer.toJSON((Object)value));
            }
            catch (JSONException jsone) {
                this.elements.add(JSONUtils.stripQuotes(value));
            }
        } else {
            this.elements.add(JSONUtils.stripQuotes(value));
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONArray)) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        if (other.size() != this.size()) {
            return false;
        }
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            Object o1 = this.get(i);
            Object o2 = other.get(i);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                return false;
            }
            if (JSONNull.getInstance().equals(o2)) {
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                JSONArray a = (JSONArray)o2;
                JSONArray e = (JSONArray)o1;
                if (a.equals(e)) continue;
                return false;
            }
            if (o1 instanceof String && o2 instanceof JSONFunction) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof JSONFunction) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof String) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (!(m1 != null && m1 != IdentityObjectMorpher.getInstance() ? !o1.equals(JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2)) : (m2 != null && m2 != IdentityObjectMorpher.getInstance() ? !JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1).equals(o2) : !o1.equals(o2)))) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        Object o = this.opt(index);
        if (o == null) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(int index) {
        Object o = this.get(index);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + index + "] is not a Boolean.");
    }

    public double getDouble(int index) {
        Object o = this.get(index);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONArray[" + index + "] is not a number.");
        }
    }

    public int getInt(int index) {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public JSONArray getJSONArray(int index) {
        Object o = this.get(index);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index) {
        Object o = this.get(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public long getLong(int index) {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) {
        return this.get(index).toString();
    }

    public int hashCode() {
        int hashcode = 29;
        for (Object element : this.elements) {
            hashcode += JSONUtils.hashCode(element);
        }
        return hashcode;
    }

    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    public boolean isArray() {
        return true;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean isExpandElements() {
        return this.expandElements;
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public String join(String separator) {
        return this.join(separator, false);
    }

    public String join(String separator, boolean stripQuotes) {
        int len = this.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            String value = JSONUtils.valueToString(this.elements.get(i));
            sb.append(stripQuotes ? JSONUtils.stripQuotes(value) : value);
        }
        return sb.toString();
    }

    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    public int length() {
        return this.elements.size();
    }

    public ListIterator listIterator() {
        return this.elements.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.elements.listIterator(index);
    }

    public Object opt(int index) {
        return index < 0 || index >= this.size() ? null : this.elements.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public Object remove(int index) {
        return this.elements.remove(index);
    }

    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    public boolean removeAll(Collection collection) {
        return this.elements.removeAll(JSONArray.fromObject(collection));
    }

    public boolean retainAll(Collection collection) {
        return this.elements.retainAll(JSONArray.fromObject(collection));
    }

    public Object set(int index, Object value) {
        Object previous = this.get(index);
        this.element(index, value);
        return previous;
    }

    public void setExpandElements(boolean expandElements) {
        this.expandElements = expandElements;
    }

    public int size() {
        return this.elements.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.elements.toArray(array);
    }

    public JSONObject toJSONObject(JSONArray names) {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < names.size(); ++i) {
            jo.element(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        if (indentFactor == 0) {
            return this.toString();
        }
        return this.toString(indentFactor, 0);
    }

    public String toString(int indentFactor, int indent) {
        int len = this.size();
        if (len == 0) {
            return "[]";
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(JSONUtils.valueToString(this.elements.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.valueToString(this.elements.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) {
        try {
            boolean b = false;
            int len = this.size();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.elements.get(i)) instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONUtils.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    protected JSONArray addString(String str) {
        if (str != null) {
            this.elements.add(str);
        }
        return this;
    }

    private JSONArray _addValue(Object value) {
        this.elements.add(this._processValue(value));
        return this;
    }

    private Object _processValue(Object value) {
        if (value != null && Class.class.isAssignableFrom(value.getClass()) || value instanceof Class) {
            return ((Class)value).getName();
        }
        if (JSONUtils.isFunction(value)) {
            if (value instanceof String) {
                value = JSONFunction.parse((String)value);
            }
            return value;
        }
        if (value instanceof JSONString) {
            return JSONSerializer.toJSON((Object)((JSONString)value));
        }
        if (value instanceof JSON) {
            return value;
        }
        if (JSONUtils.isArray(value)) {
            return JSONArray.fromObject(value);
        }
        if (value instanceof JSONTokener) {
            return JSONArray._fromJSONTokener((JSONTokener)value);
        }
        if (JSONUtils.isString(value)) {
            String str = String.valueOf(value);
            if (JSONUtils.mayBeJSON(str)) {
                try {
                    return JSONSerializer.toJSON((Object)str);
                }
                catch (JSONException jsone) {
                    return JSONUtils.stripQuotes(str);
                }
            }
            return str;
        }
        if (JSONUtils.isNumber(value)) {
            JSONUtils.testValidity(value);
            return JSONUtils.transformNumber((Number)value);
        }
        if (JSONUtils.isBoolean(value)) {
            return value;
        }
        if (value instanceof Enum) {
            return String.valueOf(value);
        }
        if (value instanceof Annotation || value != null && value.getClass().isAnnotation()) {
            throw new JSONException("Unsupported type");
        }
        JSONObject jsonObject = JSONObject.fromObject(value);
        if (jsonObject.isNullObject()) {
            return JSONNull.getInstance();
        }
        return jsonObject;
    }

    private JSONArray addValue(Object value) {
        return this._addValue(this.processValue(value));
    }

    private Object processValue(Object value) {
        JsonValueProcessor jsonValueProcessor;
        if (value != null && (jsonValueProcessor = JsonConfig.getInstance().findJsonValueProcessor(value.getClass())) != null && !JsonVerifier.isValidJsonValue(value = jsonValueProcessor.processArrayValue(value))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return this._processValue(value);
    }
}

