/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.documentdb.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.documentdb.DocumentDBAccounts;
import com.microsoft.azure.management.documentdb.implementation.DocumentDBAccountsImpl;
import com.microsoft.azure.management.documentdb.implementation.DocumentDBImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta(value=Beta.SinceVersion.V1_1_0)
public final class DocumentDBManager
extends Manager<DocumentDBManager, DocumentDBImpl> {
    private DocumentDBAccountsImpl databaseAccounts;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static DocumentDBManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new DocumentDBManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).build(), subscriptionId);
    }

    public static DocumentDBManager authenticate(RestClient restClient, String subscriptionId) {
        return new DocumentDBManager(restClient, subscriptionId);
    }

    private DocumentDBManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new DocumentDBImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public DocumentDBAccounts databaseAccounts() {
        if (this.databaseAccounts == null) {
            this.databaseAccounts = new DocumentDBAccountsImpl(this);
        }
        return this.databaseAccounts;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public DocumentDBManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return DocumentDBManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public DocumentDBManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

