/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.documentdb.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.documentdb.DocumentDBAccount;
import com.microsoft.azure.management.documentdb.DocumentDBAccounts;
import com.microsoft.azure.management.documentdb.KeyKind;
import com.microsoft.azure.management.documentdb.Location;
import com.microsoft.azure.management.documentdb.implementation.DatabaseAccountInner;
import com.microsoft.azure.management.documentdb.implementation.DatabaseAccountListConnectionStringsResult;
import com.microsoft.azure.management.documentdb.implementation.DatabaseAccountListKeysResult;
import com.microsoft.azure.management.documentdb.implementation.DatabaseAccountsInner;
import com.microsoft.azure.management.documentdb.implementation.DocumentDBAccountImpl;
import com.microsoft.azure.management.documentdb.implementation.DocumentDBImpl;
import com.microsoft.azure.management.documentdb.implementation.DocumentDBManager;
import com.microsoft.azure.management.documentdb.implementation.FailoverPolicyInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import java.util.ArrayList;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class DocumentDBAccountsImpl
extends GroupableResourcesImpl<DocumentDBAccount, DocumentDBAccountImpl, DatabaseAccountInner, DatabaseAccountsInner, DocumentDBManager>
implements DocumentDBAccounts {
    DocumentDBAccountsImpl(DocumentDBManager manager) {
        super((Object)((DocumentDBImpl)((Object)manager.inner())).databaseAccounts(), (ManagerBase)manager);
    }

    public PagedList<DocumentDBAccount> list() {
        final DocumentDBAccountsImpl self = this;
        return new GroupPagedList<DocumentDBAccount>(((DocumentDBManager)this.manager()).resourceManager().resourceGroups().list()){

            public List<DocumentDBAccount> listNextGroup(String resourceGroupName) {
                return DocumentDBAccountsImpl.this.wrapList(((DatabaseAccountsInner)self.inner()).listByResourceGroup(resourceGroupName));
            }
        };
    }

    public Observable<DocumentDBAccount> listAsync() {
        return ((DocumentDBManager)this.manager()).resourceManager().resourceGroups().listAsync().flatMap((Func1)new Func1<ResourceGroup, Observable<DocumentDBAccount>>(){

            public Observable<DocumentDBAccount> call(ResourceGroup resourceGroup) {
                return DocumentDBAccountsImpl.this.wrapPageAsync(((DatabaseAccountsInner)DocumentDBAccountsImpl.this.inner()).listByResourceGroupAsync(resourceGroup.name()));
            }
        });
    }

    public Observable<DocumentDBAccount> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((DatabaseAccountsInner)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    public PagedList<DocumentDBAccount> listByResourceGroup(String groupName) {
        return this.wrapList(((DatabaseAccountsInner)this.inner()).listByResourceGroup(groupName));
    }

    protected Observable<DatabaseAccountInner> getInnerAsync(String resourceGroupName, String name) {
        return ((DatabaseAccountsInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    public DocumentDBAccountImpl define(String name) {
        return this.wrapModel(name);
    }

    protected Completable deleteInnerAsync(String groupName, String name) {
        return ((DatabaseAccountsInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }

    protected DocumentDBAccountImpl wrapModel(String name) {
        return new DocumentDBAccountImpl(name, new DatabaseAccountInner(), (DocumentDBManager)this.manager());
    }

    protected DocumentDBAccountImpl wrapModel(DatabaseAccountInner containerServiceInner) {
        if (containerServiceInner == null) {
            return null;
        }
        return new DocumentDBAccountImpl(containerServiceInner.name(), containerServiceInner, (DocumentDBManager)this.manager());
    }

    @Override
    public void failoverPriorityChange(String groupName, String accountName, List<Location> failoverLocations) {
        this.failoverPriorityChangeAsync(groupName, accountName, failoverLocations).toBlocking().last();
    }

    @Override
    public Observable<Void> failoverPriorityChangeAsync(String groupName, String accountName, List<Location> failoverLocations) {
        ArrayList<FailoverPolicyInner> policyInners = new ArrayList<FailoverPolicyInner>();
        for (int i = 0; i < failoverLocations.size(); ++i) {
            Location location = failoverLocations.get(i);
            FailoverPolicyInner policyInner = new FailoverPolicyInner();
            policyInner.withLocationName(location.locationName());
            policyInner.withFailoverPriority(i);
            policyInners.add(policyInner);
        }
        return ((DocumentDBImpl)((Object)((DocumentDBManager)this.manager()).inner())).databaseAccounts().failoverPriorityChangeAsync(groupName, accountName, policyInners);
    }

    @Override
    public DatabaseAccountListKeysResult listKeys(String groupName, String accountName) {
        return (DatabaseAccountListKeysResult)this.listKeysAsync(groupName, accountName).toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListKeysResult> listKeysAsync(String groupName, String accountName) {
        return ((DocumentDBImpl)((Object)((DocumentDBManager)this.manager()).inner())).databaseAccounts().listKeysAsync(groupName, accountName);
    }

    @Override
    public DatabaseAccountListConnectionStringsResult listConnectionStrings(String groupName, String accountName) {
        return (DatabaseAccountListConnectionStringsResult)this.listConnectionStringsAsync(groupName, accountName).toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync(String groupName, String accountName) {
        return ((DocumentDBImpl)((Object)((DocumentDBManager)this.manager()).inner())).databaseAccounts().listConnectionStringsAsync(groupName, accountName);
    }

    @Override
    public void regenerateKey(String groupName, String accountName, KeyKind keyKind) {
        this.regenerateKeyAsync(groupName, accountName, keyKind).toBlocking().last();
    }

    @Override
    public Observable<Void> regenerateKeyAsync(String groupName, String accountName, KeyKind keyKind) {
        return ((DocumentDBImpl)((Object)((DocumentDBManager)this.manager()).inner())).databaseAccounts().regenerateKeyAsync(groupName, accountName, keyKind);
    }
}

