/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.VpnServerConfigurationsResponseInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VpnServerConfigurationsAssociatedWithVirtualWansInner {
    private VpnServerConfigurationsAssociatedWithVirtualWansService service;
    private NetworkManagementClientImpl client;

    public VpnServerConfigurationsAssociatedWithVirtualWansInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnServerConfigurationsAssociatedWithVirtualWansService)retrofit.create(VpnServerConfigurationsAssociatedWithVirtualWansService.class);
        this.client = client;
    }

    public VpnServerConfigurationsResponseInner list(String resourceGroupName, String virtualWANName) {
        return (VpnServerConfigurationsResponseInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().last()).body();
    }

    public ServiceFuture<VpnServerConfigurationsResponseInner> listAsync(String resourceGroupName, String virtualWANName, ServiceCallback<VpnServerConfigurationsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<VpnServerConfigurationsResponseInner> listAsync(String resourceGroupName, String virtualWANName) {
        return this.listWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<VpnServerConfigurationsResponseInner>, VpnServerConfigurationsResponseInner>(){

            public VpnServerConfigurationsResponseInner call(ServiceResponse<VpnServerConfigurationsResponseInner> response) {
                return (VpnServerConfigurationsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnServerConfigurationsResponseInner>> listWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.list(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<VpnServerConfigurationsResponseInner>(){}.getType());
    }

    public VpnServerConfigurationsResponseInner beginList(String resourceGroupName, String virtualWANName) {
        return (VpnServerConfigurationsResponseInner)((ServiceResponse)this.beginListWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single()).body();
    }

    public ServiceFuture<VpnServerConfigurationsResponseInner> beginListAsync(String resourceGroupName, String virtualWANName, ServiceCallback<VpnServerConfigurationsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginListWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<VpnServerConfigurationsResponseInner> beginListAsync(String resourceGroupName, String virtualWANName) {
        return this.beginListWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<VpnServerConfigurationsResponseInner>, VpnServerConfigurationsResponseInner>(){

            public VpnServerConfigurationsResponseInner call(ServiceResponse<VpnServerConfigurationsResponseInner> response) {
                return (VpnServerConfigurationsResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnServerConfigurationsResponseInner>> beginListWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginList(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationsResponseInner>>>(){

            public Observable<ServiceResponse<VpnServerConfigurationsResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnServerConfigurationsAssociatedWithVirtualWansInner.this.beginListDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnServerConfigurationsResponseInner> beginListDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnServerConfigurationsResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VpnServerConfigurationsAssociatedWithVirtualWansService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurationsAssociatedWithVirtualWans list"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/vpnServerConfigurations")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWANName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurationsAssociatedWithVirtualWans beginList"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/vpnServerConfigurations")
        public Observable<Response<ResponseBody>> beginList(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWANName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

