/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.ServiceEndpointPolicyDefinitionInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ServiceEndpointPolicyDefinitionsInner {
    private ServiceEndpointPolicyDefinitionsService service;
    private NetworkManagementClientImpl client;

    public ServiceEndpointPolicyDefinitionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ServiceEndpointPolicyDefinitionsService)retrofit.create(ServiceEndpointPolicyDefinitionsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPolicyDefinitionsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServiceEndpointPolicyDefinitionInner get(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        return (ServiceEndpointPolicyDefinitionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyDefinitionInner> getAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyDefinitionInner> getAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyDefinitionInner>, ServiceEndpointPolicyDefinitionInner>(){

            public ServiceEndpointPolicyDefinitionInner call(ServiceResponse<ServiceEndpointPolicyDefinitionInner> response) {
                return (ServiceEndpointPolicyDefinitionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> getWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>>>(){

            public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPolicyDefinitionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceEndpointPolicyDefinitionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceEndpointPolicyDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServiceEndpointPolicyDefinitionInner createOrUpdate(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        return (ServiceEndpointPolicyDefinitionInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions).toBlocking().last()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyDefinitionInner> createOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions, ServiceCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyDefinitionInner> createOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyDefinitionInner>, ServiceEndpointPolicyDefinitionInner>(){

            public ServiceEndpointPolicyDefinitionInner call(ServiceResponse<ServiceEndpointPolicyDefinitionInner> response) {
                return (ServiceEndpointPolicyDefinitionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitions == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitions is required and cannot be null.");
        }
        Validator.validate((Object)((Object)serviceEndpointPolicyDefinitions));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), serviceEndpointPolicyDefinitions, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServiceEndpointPolicyDefinitionInner>(){}.getType());
    }

    public ServiceEndpointPolicyDefinitionInner beginCreateOrUpdate(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        return (ServiceEndpointPolicyDefinitionInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceEndpointPolicyDefinitionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions, ServiceCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions), serviceCallback);
    }

    public Observable<ServiceEndpointPolicyDefinitionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, serviceEndpointPolicyDefinitions).map((Func1)new Func1<ServiceResponse<ServiceEndpointPolicyDefinitionInner>, ServiceEndpointPolicyDefinitionInner>(){

            public ServiceEndpointPolicyDefinitionInner call(ServiceResponse<ServiceEndpointPolicyDefinitionInner> response) {
                return (ServiceEndpointPolicyDefinitionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName, String serviceEndpointPolicyDefinitionName, ServiceEndpointPolicyDefinitionInner serviceEndpointPolicyDefinitions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitionName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (serviceEndpointPolicyDefinitions == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyDefinitions is required and cannot be null.");
        }
        Validator.validate((Object)((Object)serviceEndpointPolicyDefinitions));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, serviceEndpointPolicyName, serviceEndpointPolicyDefinitionName, this.client.subscriptionId(), serviceEndpointPolicyDefinitions, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>>>(){

            public Observable<ServiceResponse<ServiceEndpointPolicyDefinitionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceEndpointPolicyDefinitionsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceEndpointPolicyDefinitionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceEndpointPolicyDefinitionInner>(){}.getType()).register(201, new TypeToken<ServiceEndpointPolicyDefinitionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServiceEndpointPolicyDefinitionInner> listByResourceGroup(String resourceGroupName, String serviceEndpointPolicyName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, serviceEndpointPolicyName).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyDefinitionInner>((Page)response.body()){

            public Page<ServiceEndpointPolicyDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServiceEndpointPolicyDefinitionsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName, ListOperationCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, serviceEndpointPolicyName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(String nextPageLink) {
                return ServiceEndpointPolicyDefinitionsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceEndpointPolicyName).map((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>, Page<ServiceEndpointPolicyDefinitionInner>>(){

            public Page<ServiceEndpointPolicyDefinitionInner> call(ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, serviceEndpointPolicyName).concatMap((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServiceEndpointPolicyDefinitionsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String serviceEndpointPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceEndpointPolicyName == null) {
            throw new IllegalArgumentException("Parameter serviceEndpointPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, serviceEndpointPolicyName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServiceEndpointPolicyDefinitionsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServiceEndpointPolicyDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServiceEndpointPolicyDefinitionInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServiceEndpointPolicyDefinitionInner>((Page)response.body()){

            public Page<ServiceEndpointPolicyDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServiceEndpointPolicyDefinitionsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ServiceEndpointPolicyDefinitionInner>> serviceFuture, ListOperationCallback<ServiceEndpointPolicyDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(String nextPageLink) {
                return ServiceEndpointPolicyDefinitionsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>, Page<ServiceEndpointPolicyDefinitionInner>>(){

            public Page<ServiceEndpointPolicyDefinitionInner> call(ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServiceEndpointPolicyDefinitionsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<ServiceEndpointPolicyDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServiceEndpointPolicyDefinitionsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServiceEndpointPolicyDefinitionInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServiceEndpointPolicyDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServiceEndpointPolicyDefinitionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="serviceEndpointPolicyDefinitionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="serviceEndpointPolicyDefinitionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="serviceEndpointPolicyDefinitionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="serviceEndpointPolicyDefinitionName") String var3, @Path(value="subscriptionId") String var4, @Body ServiceEndpointPolicyDefinitionInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="serviceEndpointPolicyDefinitionName") String var3, @Path(value="subscriptionId") String var4, @Body ServiceEndpointPolicyDefinitionInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="serviceEndpointPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ServiceEndpointPolicyDefinitions listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

