/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.CheckPrivateLinkServiceVisibilityRequest;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.AutoApprovedPrivateLinkServiceInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PrivateEndpointConnectionInner;
import com.microsoft.azure.management.network.implementation.PrivateLinkServiceInner;
import com.microsoft.azure.management.network.implementation.PrivateLinkServiceVisibilityInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PrivateLinkServicesInner
implements InnerSupportsGet<PrivateLinkServiceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<PrivateLinkServiceInner> {
    private PrivateLinkServicesService service;
    private NetworkManagementClientImpl client;

    public PrivateLinkServicesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (PrivateLinkServicesService)retrofit.create(PrivateLinkServicesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String serviceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serviceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serviceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serviceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serviceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serviceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serviceName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serviceName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serviceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serviceName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serviceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, serviceName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PrivateLinkServiceInner getByResourceGroup(String resourceGroupName, String serviceName) {
        return (PrivateLinkServiceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateLinkServiceInner> getByResourceGroupAsync(String resourceGroupName, String serviceName, ServiceCallback<PrivateLinkServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName), serviceCallback);
    }

    public Observable<PrivateLinkServiceInner> getByResourceGroupAsync(String resourceGroupName, String serviceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName).map((Func1)new Func1<ServiceResponse<PrivateLinkServiceInner>, PrivateLinkServiceInner>(){

            public PrivateLinkServiceInner call(ServiceResponse<PrivateLinkServiceInner> response) {
                return (PrivateLinkServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkServiceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, serviceName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceInner>>>(){

            public Observable<ServiceResponse<PrivateLinkServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PrivateLinkServiceInner getByResourceGroup(String resourceGroupName, String serviceName, String expand) {
        return (PrivateLinkServiceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateLinkServiceInner> getByResourceGroupAsync(String resourceGroupName, String serviceName, String expand, ServiceCallback<PrivateLinkServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName, expand), serviceCallback);
    }

    public Observable<PrivateLinkServiceInner> getByResourceGroupAsync(String resourceGroupName, String serviceName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, serviceName, expand).map((Func1)new Func1<ServiceResponse<PrivateLinkServiceInner>, PrivateLinkServiceInner>(){

            public PrivateLinkServiceInner call(ServiceResponse<PrivateLinkServiceInner> response) {
                return (PrivateLinkServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkServiceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String serviceName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, serviceName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceInner>>>(){

            public Observable<ServiceResponse<PrivateLinkServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkServiceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkServiceInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PrivateLinkServiceInner createOrUpdate(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        return (PrivateLinkServiceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<PrivateLinkServiceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters, ServiceCallback<PrivateLinkServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters), serviceCallback);
    }

    public Observable<PrivateLinkServiceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters).map((Func1)new Func1<ServiceResponse<PrivateLinkServiceInner>, PrivateLinkServiceInner>(){

            public PrivateLinkServiceInner call(ServiceResponse<PrivateLinkServiceInner> response) {
                return (PrivateLinkServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkServiceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serviceName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<PrivateLinkServiceInner>(){}.getType());
    }

    public PrivateLinkServiceInner beginCreateOrUpdate(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        return (PrivateLinkServiceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateLinkServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters, ServiceCallback<PrivateLinkServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters), serviceCallback);
    }

    public Observable<PrivateLinkServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serviceName, parameters).map((Func1)new Func1<ServiceResponse<PrivateLinkServiceInner>, PrivateLinkServiceInner>(){

            public PrivateLinkServiceInner call(ServiceResponse<PrivateLinkServiceInner> response) {
                return (PrivateLinkServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkServiceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serviceName, PrivateLinkServiceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, serviceName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceInner>>>(){

            public Observable<ServiceResponse<PrivateLinkServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkServiceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkServiceInner>(){}.getType()).register(201, new TypeToken<PrivateLinkServiceInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateLinkServiceInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<PrivateLinkServiceInner>((Page)response.body()){

            public Page<PrivateLinkServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateLinkServiceInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<PrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateLinkServiceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Page<PrivateLinkServiceInner>>(){

            public Page<PrivateLinkServiceInner> call(ServiceResponse<Page<PrivateLinkServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(ServiceResponse<Page<PrivateLinkServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateLinkServiceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateLinkServiceInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateLinkServiceInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<PrivateLinkServiceInner>((Page)response.body()){

            public Page<PrivateLinkServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateLinkServiceInner>> listAsync(ListOperationCallback<PrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateLinkServiceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Page<PrivateLinkServiceInner>>(){

            public Page<PrivateLinkServiceInner> call(ServiceResponse<Page<PrivateLinkServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(ServiceResponse<Page<PrivateLinkServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateLinkServiceInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateLinkServiceInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PrivateEndpointConnectionInner getPrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        return this.getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.getPrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.getPrivateEndpointConnectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PrivateEndpointConnectionInner getPrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName, String expand) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, String expand, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, expand), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, String expand) {
        return this.getPrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, expand).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getPrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getPrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.getPrivateEndpointConnectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> getPrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PrivateEndpointConnectionInner updatePrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName, PrivateEndpointConnectionInner parameters) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.updatePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> updatePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, PrivateEndpointConnectionInner parameters, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updatePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, parameters), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> updatePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, PrivateEndpointConnectionInner parameters) {
        return this.updatePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName, parameters).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> updatePrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName, PrivateEndpointConnectionInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.updatePrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.updatePrivateEndpointConnectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> updatePrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public void deletePrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName) {
        ((ServiceResponse)this.deletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deletePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName), serviceCallback);
    }

    public Observable<Void> deletePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        return this.deletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deletePrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.deletePrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeletePrivateEndpointConnection(String resourceGroupName, String serviceName, String peConnectionName) {
        ((ServiceResponse)this.beginDeletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName), serviceCallback);
    }

    public Observable<Void> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        return this.beginDeletePrivateEndpointConnectionWithServiceResponseAsync(resourceGroupName, serviceName, peConnectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeletePrivateEndpointConnectionWithServiceResponseAsync(String resourceGroupName, String serviceName, String peConnectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (peConnectionName == null) {
            throw new IllegalArgumentException("Parameter peConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDeletePrivateEndpointConnection(resourceGroupName, serviceName, peConnectionName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.beginDeletePrivateEndpointConnectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeletePrivateEndpointConnectionDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateEndpointConnectionInner> listPrivateEndpointConnections(String resourceGroupName, String serviceName) {
        ServiceResponse response = (ServiceResponse)this.listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, serviceName).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>((Page)response.body()){

            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsAsync(String resourceGroupName, String serviceName, ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, serviceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsAsync(String resourceGroupName, String serviceName) {
        return this.listPrivateEndpointConnectionsWithServiceResponseAsync(resourceGroupName, serviceName).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>(){

            public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsWithServiceResponseAsync(String resourceGroupName, String serviceName) {
        return this.listPrivateEndpointConnectionsSinglePageAsync(resourceGroupName, serviceName).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsSinglePageAsync(String resourceGroupName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Parameter serviceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listPrivateEndpointConnections(resourceGroupName, serviceName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listPrivateEndpointConnectionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateEndpointConnectionInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PrivateLinkServiceVisibilityInner checkPrivateLinkServiceVisibility(String location) {
        return (PrivateLinkServiceVisibilityInner)((ServiceResponse)this.checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityAsync(String location, ServiceCallback<PrivateLinkServiceVisibilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location), serviceCallback);
    }

    public Observable<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityAsync(String location) {
        return this.checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<PrivateLinkServiceVisibilityInner>, PrivateLinkServiceVisibilityInner>(){

            public PrivateLinkServiceVisibilityInner call(ServiceResponse<PrivateLinkServiceVisibilityInner> response) {
                return (PrivateLinkServiceVisibilityInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> checkPrivateLinkServiceVisibilityWithServiceResponseAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object privateLinkServiceAlias = null;
        CheckPrivateLinkServiceVisibilityRequest parameters = new CheckPrivateLinkServiceVisibilityRequest();
        parameters.withPrivateLinkServiceAlias(null);
        return this.service.checkPrivateLinkServiceVisibility(location, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>>>(){

            public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.checkPrivateLinkServiceVisibilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PrivateLinkServiceVisibilityInner checkPrivateLinkServiceVisibility(String location, String privateLinkServiceAlias) {
        return (PrivateLinkServiceVisibilityInner)((ServiceResponse)this.checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location, privateLinkServiceAlias).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityAsync(String location, String privateLinkServiceAlias, ServiceCallback<PrivateLinkServiceVisibilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location, privateLinkServiceAlias), serviceCallback);
    }

    public Observable<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityAsync(String location, String privateLinkServiceAlias) {
        return this.checkPrivateLinkServiceVisibilityWithServiceResponseAsync(location, privateLinkServiceAlias).map((Func1)new Func1<ServiceResponse<PrivateLinkServiceVisibilityInner>, PrivateLinkServiceVisibilityInner>(){

            public PrivateLinkServiceVisibilityInner call(ServiceResponse<PrivateLinkServiceVisibilityInner> response) {
                return (PrivateLinkServiceVisibilityInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> checkPrivateLinkServiceVisibilityWithServiceResponseAsync(String location, String privateLinkServiceAlias) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        CheckPrivateLinkServiceVisibilityRequest parameters = new CheckPrivateLinkServiceVisibilityRequest();
        parameters.withPrivateLinkServiceAlias(privateLinkServiceAlias);
        return this.service.checkPrivateLinkServiceVisibility(location, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>>>(){

            public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.checkPrivateLinkServiceVisibilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkServiceVisibilityInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateLinkServiceVisibilityInner checkPrivateLinkServiceVisibilityByResourceGroup(String location, String resourceGroupName) {
        return (PrivateLinkServiceVisibilityInner)((ServiceResponse)this.checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupAsync(String location, String resourceGroupName, ServiceCallback<PrivateLinkServiceVisibilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName), serviceCallback);
    }

    public Observable<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupAsync(String location, String resourceGroupName) {
        return this.checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName).map((Func1)new Func1<ServiceResponse<PrivateLinkServiceVisibilityInner>, PrivateLinkServiceVisibilityInner>(){

            public PrivateLinkServiceVisibilityInner call(ServiceResponse<PrivateLinkServiceVisibilityInner> response) {
                return (PrivateLinkServiceVisibilityInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(String location, String resourceGroupName) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object privateLinkServiceAlias = null;
        CheckPrivateLinkServiceVisibilityRequest parameters = new CheckPrivateLinkServiceVisibilityRequest();
        parameters.withPrivateLinkServiceAlias(null);
        return this.service.checkPrivateLinkServiceVisibilityByResourceGroup(location, resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>>>(){

            public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.checkPrivateLinkServiceVisibilityByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PrivateLinkServiceVisibilityInner checkPrivateLinkServiceVisibilityByResourceGroup(String location, String resourceGroupName, String privateLinkServiceAlias) {
        return (PrivateLinkServiceVisibilityInner)((ServiceResponse)this.checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName, privateLinkServiceAlias).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupAsync(String location, String resourceGroupName, String privateLinkServiceAlias, ServiceCallback<PrivateLinkServiceVisibilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName, privateLinkServiceAlias), serviceCallback);
    }

    public Observable<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupAsync(String location, String resourceGroupName, String privateLinkServiceAlias) {
        return this.checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(location, resourceGroupName, privateLinkServiceAlias).map((Func1)new Func1<ServiceResponse<PrivateLinkServiceVisibilityInner>, PrivateLinkServiceVisibilityInner>(){

            public PrivateLinkServiceVisibilityInner call(ServiceResponse<PrivateLinkServiceVisibilityInner> response) {
                return (PrivateLinkServiceVisibilityInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> checkPrivateLinkServiceVisibilityByResourceGroupWithServiceResponseAsync(String location, String resourceGroupName, String privateLinkServiceAlias) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        CheckPrivateLinkServiceVisibilityRequest parameters = new CheckPrivateLinkServiceVisibilityRequest();
        parameters.withPrivateLinkServiceAlias(privateLinkServiceAlias);
        return this.service.checkPrivateLinkServiceVisibilityByResourceGroup(location, resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>>>(){

            public Observable<ServiceResponse<PrivateLinkServiceVisibilityInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkServicesInner.this.checkPrivateLinkServiceVisibilityByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkServiceVisibilityInner> checkPrivateLinkServiceVisibilityByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkServiceVisibilityInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AutoApprovedPrivateLinkServiceInner> listAutoApprovedPrivateLinkServices(String location) {
        ServiceResponse response = (ServiceResponse)this.listAutoApprovedPrivateLinkServicesSinglePageAsync(location).toBlocking().single();
        return new PagedList<AutoApprovedPrivateLinkServiceInner>((Page)response.body()){

            public Page<AutoApprovedPrivateLinkServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesAsync(String location, ListOperationCallback<AutoApprovedPrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAutoApprovedPrivateLinkServicesSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesAsync(String location) {
        return this.listAutoApprovedPrivateLinkServicesWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Page<AutoApprovedPrivateLinkServiceInner>>(){

            public Page<AutoApprovedPrivateLinkServiceInner> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesWithServiceResponseAsync(String location) {
        return this.listAutoApprovedPrivateLinkServicesSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesSinglePageAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listAutoApprovedPrivateLinkServices(location, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AutoApprovedPrivateLinkServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AutoApprovedPrivateLinkServiceInner> listAutoApprovedPrivateLinkServicesByResourceGroup(String location, String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listAutoApprovedPrivateLinkServicesByResourceGroupSinglePageAsync(location, resourceGroupName).toBlocking().single();
        return new PagedList<AutoApprovedPrivateLinkServiceInner>((Page)response.body()){

            public Page<AutoApprovedPrivateLinkServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupAsync(String location, String resourceGroupName, ListOperationCallback<AutoApprovedPrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAutoApprovedPrivateLinkServicesByResourceGroupSinglePageAsync(location, resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupAsync(String location, String resourceGroupName) {
        return this.listAutoApprovedPrivateLinkServicesByResourceGroupWithServiceResponseAsync(location, resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Page<AutoApprovedPrivateLinkServiceInner>>(){

            public Page<AutoApprovedPrivateLinkServiceInner> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesByResourceGroupWithServiceResponseAsync(String location, String resourceGroupName) {
        return this.listAutoApprovedPrivateLinkServicesByResourceGroupSinglePageAsync(location, resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesByResourceGroupSinglePageAsync(String location, String resourceGroupName) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listAutoApprovedPrivateLinkServicesByResourceGroup(location, resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AutoApprovedPrivateLinkServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PrivateLinkServiceInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateLinkServiceInner>((Page)response.body()){

            public Page<PrivateLinkServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateLinkServiceInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<PrivateLinkServiceInner>> serviceFuture, ListOperationCallback<PrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateLinkServiceInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Page<PrivateLinkServiceInner>>(){

            public Page<PrivateLinkServiceInner> call(ServiceResponse<Page<PrivateLinkServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(ServiceResponse<Page<PrivateLinkServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateLinkServiceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateLinkServiceInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateLinkServiceInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateLinkServiceInner>((Page)response.body()){

            public Page<PrivateLinkServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateLinkServiceInner>> listNextAsync(String nextPageLink, ServiceFuture<List<PrivateLinkServiceInner>> serviceFuture, ListOperationCallback<PrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateLinkServiceInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Page<PrivateLinkServiceInner>>(){

            public Page<PrivateLinkServiceInner> call(ServiceResponse<Page<PrivateLinkServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateLinkServiceInner>>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(ServiceResponse<Page<PrivateLinkServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateLinkServiceInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateLinkServiceInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<PrivateEndpointConnectionInner> listPrivateEndpointConnectionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>((Page)response.body()){

            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextAsync(String nextPageLink, ServiceFuture<List<PrivateEndpointConnectionInner>> serviceFuture, ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextAsync(String nextPageLink) {
        return this.listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>(){

            public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listPrivateEndpointConnectionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listPrivateEndpointConnectionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listPrivateEndpointConnectionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listPrivateEndpointConnectionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listPrivateEndpointConnectionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> listPrivateEndpointConnectionsNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateEndpointConnectionInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<AutoApprovedPrivateLinkServiceInner> listAutoApprovedPrivateLinkServicesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AutoApprovedPrivateLinkServiceInner>((Page)response.body()){

            public Page<AutoApprovedPrivateLinkServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesNextAsync(String nextPageLink, ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> serviceFuture, ListOperationCallback<AutoApprovedPrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesNextAsync(String nextPageLink) {
        return this.listAutoApprovedPrivateLinkServicesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Page<AutoApprovedPrivateLinkServiceInner>>(){

            public Page<AutoApprovedPrivateLinkServiceInner> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAutoApprovedPrivateLinkServicesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAutoApprovedPrivateLinkServicesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AutoApprovedPrivateLinkServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AutoApprovedPrivateLinkServiceInner> listAutoApprovedPrivateLinkServicesByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AutoApprovedPrivateLinkServiceInner>((Page)response.body()){

            public Page<AutoApprovedPrivateLinkServiceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<AutoApprovedPrivateLinkServiceInner>> serviceFuture, ListOperationCallback<AutoApprovedPrivateLinkServiceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(String nextPageLink) {
                return PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupNextAsync(String nextPageLink) {
        return this.listAutoApprovedPrivateLinkServicesByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Page<AutoApprovedPrivateLinkServiceInner>>(){

            public Page<AutoApprovedPrivateLinkServiceInner> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> listAutoApprovedPrivateLinkServicesByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAutoApprovedPrivateLinkServicesByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoApprovedPrivateLinkServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkServicesInner.this.listAutoApprovedPrivateLinkServicesByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AutoApprovedPrivateLinkServiceInner>> listAutoApprovedPrivateLinkServicesByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AutoApprovedPrivateLinkServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PrivateLinkServicesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="subscriptionId") String var3, @Body PrivateLinkServiceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="subscriptionId") String var3, @Body PrivateLinkServiceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/privateLinkServices")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices getPrivateEndpointConnection"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}")
        public Observable<Response<ResponseBody>> getPrivateEndpointConnection(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="peConnectionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Query(value="$expand") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices updatePrivateEndpointConnection"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}")
        public Observable<Response<ResponseBody>> updatePrivateEndpointConnection(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="peConnectionName") String var3, @Path(value="subscriptionId") String var4, @Body PrivateEndpointConnectionInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices deletePrivateEndpointConnection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deletePrivateEndpointConnection(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="peConnectionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices beginDeletePrivateEndpointConnection"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeletePrivateEndpointConnection(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="peConnectionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listPrivateEndpointConnections"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections")
        public Observable<Response<ResponseBody>> listPrivateEndpointConnections(@Path(value="resourceGroupName") String var1, @Path(value="serviceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices checkPrivateLinkServiceVisibility"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/checkPrivateLinkServiceVisibility")
        public Observable<Response<ResponseBody>> checkPrivateLinkServiceVisibility(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body CheckPrivateLinkServiceVisibilityRequest var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices checkPrivateLinkServiceVisibilityByResourceGroup"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/locations/{location}/checkPrivateLinkServiceVisibility")
        public Observable<Response<ResponseBody>> checkPrivateLinkServiceVisibilityByResourceGroup(@Path(value="location") String var1, @Path(value="resourceGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body CheckPrivateLinkServiceVisibilityRequest var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listAutoApprovedPrivateLinkServices"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/autoApprovedPrivateLinkServices")
        public Observable<Response<ResponseBody>> listAutoApprovedPrivateLinkServices(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listAutoApprovedPrivateLinkServicesByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/locations/{location}/autoApprovedPrivateLinkServices")
        public Observable<Response<ResponseBody>> listAutoApprovedPrivateLinkServicesByResourceGroup(@Path(value="location") String var1, @Path(value="resourceGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listPrivateEndpointConnectionsNext"})
        @GET
        public Observable<Response<ResponseBody>> listPrivateEndpointConnectionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listAutoApprovedPrivateLinkServicesNext"})
        @GET
        public Observable<Response<ResponseBody>> listAutoApprovedPrivateLinkServicesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.PrivateLinkServices listAutoApprovedPrivateLinkServicesByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listAutoApprovedPrivateLinkServicesByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

