/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NatGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class NatGatewaysInner
implements InnerSupportsGet<NatGatewayInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<NatGatewayInner> {
    private NatGatewaysService service;
    private NetworkManagementClientImpl client;

    public NatGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (NatGatewaysService)retrofit.create(NatGatewaysService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String natGatewayName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, natGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String natGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, natGatewayName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String natGatewayName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, natGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String natGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (natGatewayName == null) {
            throw new IllegalArgumentException("Parameter natGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, natGatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String natGatewayName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, natGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String natGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, natGatewayName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String natGatewayName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, natGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String natGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (natGatewayName == null) {
            throw new IllegalArgumentException("Parameter natGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, natGatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NatGatewaysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NatGatewayInner getByResourceGroup(String resourceGroupName, String natGatewayName) {
        return (NatGatewayInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, natGatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<NatGatewayInner> getByResourceGroupAsync(String resourceGroupName, String natGatewayName, ServiceCallback<NatGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, natGatewayName), serviceCallback);
    }

    public Observable<NatGatewayInner> getByResourceGroupAsync(String resourceGroupName, String natGatewayName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, natGatewayName).map((Func1)new Func1<ServiceResponse<NatGatewayInner>, NatGatewayInner>(){

            public NatGatewayInner call(ServiceResponse<NatGatewayInner> response) {
                return (NatGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NatGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String natGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (natGatewayName == null) {
            throw new IllegalArgumentException("Parameter natGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, natGatewayName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NatGatewayInner>>>(){

            public Observable<ServiceResponse<NatGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NatGatewaysInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public NatGatewayInner getByResourceGroup(String resourceGroupName, String natGatewayName, String expand) {
        return (NatGatewayInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, natGatewayName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<NatGatewayInner> getByResourceGroupAsync(String resourceGroupName, String natGatewayName, String expand, ServiceCallback<NatGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, natGatewayName, expand), serviceCallback);
    }

    public Observable<NatGatewayInner> getByResourceGroupAsync(String resourceGroupName, String natGatewayName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, natGatewayName, expand).map((Func1)new Func1<ServiceResponse<NatGatewayInner>, NatGatewayInner>(){

            public NatGatewayInner call(ServiceResponse<NatGatewayInner> response) {
                return (NatGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NatGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String natGatewayName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (natGatewayName == null) {
            throw new IllegalArgumentException("Parameter natGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, natGatewayName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NatGatewayInner>>>(){

            public Observable<ServiceResponse<NatGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NatGatewaysInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NatGatewayInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NatGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NatGatewayInner createOrUpdate(String resourceGroupName, String natGatewayName, NatGatewayInner parameters) {
        return (NatGatewayInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, natGatewayName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<NatGatewayInner> createOrUpdateAsync(String resourceGroupName, String natGatewayName, NatGatewayInner parameters, ServiceCallback<NatGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, natGatewayName, parameters), serviceCallback);
    }

    public Observable<NatGatewayInner> createOrUpdateAsync(String resourceGroupName, String natGatewayName, NatGatewayInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, natGatewayName, parameters).map((Func1)new Func1<ServiceResponse<NatGatewayInner>, NatGatewayInner>(){

            public NatGatewayInner call(ServiceResponse<NatGatewayInner> response) {
                return (NatGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NatGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String natGatewayName, NatGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (natGatewayName == null) {
            throw new IllegalArgumentException("Parameter natGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, natGatewayName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<NatGatewayInner>(){}.getType());
    }

    public NatGatewayInner beginCreateOrUpdate(String resourceGroupName, String natGatewayName, NatGatewayInner parameters) {
        return (NatGatewayInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, natGatewayName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<NatGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String natGatewayName, NatGatewayInner parameters, ServiceCallback<NatGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, natGatewayName, parameters), serviceCallback);
    }

    public Observable<NatGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String natGatewayName, NatGatewayInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, natGatewayName, parameters).map((Func1)new Func1<ServiceResponse<NatGatewayInner>, NatGatewayInner>(){

            public NatGatewayInner call(ServiceResponse<NatGatewayInner> response) {
                return (NatGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NatGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String natGatewayName, NatGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (natGatewayName == null) {
            throw new IllegalArgumentException("Parameter natGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, natGatewayName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NatGatewayInner>>>(){

            public Observable<ServiceResponse<NatGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NatGatewaysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NatGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NatGatewayInner>(){}.getType()).register(201, new TypeToken<NatGatewayInner>(){}.getType()).register(202, new TypeToken<NatGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public NatGatewayInner updateTags(String resourceGroupName, String natGatewayName) {
        return (NatGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, natGatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<NatGatewayInner> updateTagsAsync(String resourceGroupName, String natGatewayName, ServiceCallback<NatGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, natGatewayName), serviceCallback);
    }

    public Observable<NatGatewayInner> updateTagsAsync(String resourceGroupName, String natGatewayName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, natGatewayName).map((Func1)new Func1<ServiceResponse<NatGatewayInner>, NatGatewayInner>(){

            public NatGatewayInner call(ServiceResponse<NatGatewayInner> response) {
                return (NatGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NatGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String natGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (natGatewayName == null) {
            throw new IllegalArgumentException("Parameter natGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.updateTags(resourceGroupName, natGatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NatGatewayInner>>>(){

            public Observable<ServiceResponse<NatGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NatGatewaysInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public NatGatewayInner updateTags(String resourceGroupName, String natGatewayName, Map<String, String> tags) {
        return (NatGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, natGatewayName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<NatGatewayInner> updateTagsAsync(String resourceGroupName, String natGatewayName, Map<String, String> tags, ServiceCallback<NatGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, natGatewayName, tags), serviceCallback);
    }

    public Observable<NatGatewayInner> updateTagsAsync(String resourceGroupName, String natGatewayName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, natGatewayName, tags).map((Func1)new Func1<ServiceResponse<NatGatewayInner>, NatGatewayInner>(){

            public NatGatewayInner call(ServiceResponse<NatGatewayInner> response) {
                return (NatGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<NatGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String natGatewayName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (natGatewayName == null) {
            throw new IllegalArgumentException("Parameter natGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.updateTags(resourceGroupName, natGatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<NatGatewayInner>>>(){

            public Observable<ServiceResponse<NatGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = NatGatewaysInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<NatGatewayInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NatGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NatGatewayInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<NatGatewayInner>((Page)response.body()){

            public Page<NatGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NatGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NatGatewayInner>> listAsync(ListOperationCallback<NatGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(String nextPageLink) {
                return NatGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NatGatewayInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<NatGatewayInner>>, Page<NatGatewayInner>>(){

            public Page<NatGatewayInner> call(ServiceResponse<Page<NatGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NatGatewayInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<NatGatewayInner>>, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(ServiceResponse<Page<NatGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NatGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NatGatewayInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NatGatewaysInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NatGatewayInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NatGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NatGatewayInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<NatGatewayInner>((Page)response.body()){

            public Page<NatGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NatGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NatGatewayInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<NatGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(String nextPageLink) {
                return NatGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NatGatewayInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<NatGatewayInner>>, Page<NatGatewayInner>>(){

            public Page<NatGatewayInner> call(ServiceResponse<Page<NatGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NatGatewayInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<NatGatewayInner>>, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(ServiceResponse<Page<NatGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NatGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NatGatewayInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NatGatewaysInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NatGatewayInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NatGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NatGatewayInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NatGatewayInner>((Page)response.body()){

            public Page<NatGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NatGatewaysInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NatGatewayInner>> listNextAsync(String nextPageLink, ServiceFuture<List<NatGatewayInner>> serviceFuture, ListOperationCallback<NatGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(String nextPageLink) {
                return NatGatewaysInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NatGatewayInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<NatGatewayInner>>, Page<NatGatewayInner>>(){

            public Page<NatGatewayInner> call(ServiceResponse<Page<NatGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NatGatewayInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<NatGatewayInner>>, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(ServiceResponse<Page<NatGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NatGatewaysInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NatGatewayInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NatGatewaysInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NatGatewayInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NatGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NatGatewayInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NatGatewayInner>((Page)response.body()){

            public Page<NatGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)NatGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NatGatewayInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<NatGatewayInner>> serviceFuture, ListOperationCallback<NatGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(String nextPageLink) {
                return NatGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NatGatewayInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<NatGatewayInner>>, Page<NatGatewayInner>>(){

            public Page<NatGatewayInner> call(ServiceResponse<Page<NatGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NatGatewayInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<NatGatewayInner>>, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(ServiceResponse<Page<NatGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(NatGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NatGatewayInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NatGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<NatGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = NatGatewaysInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NatGatewayInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NatGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface NatGatewaysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="natGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="natGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="natGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="natGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body NatGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="natGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body NatGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="natGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/natGateways")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.NatGateways listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

