/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.FirewallPolicyRuleGroupInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FirewallPolicyRuleGroupsInner {
    private FirewallPolicyRuleGroupsService service;
    private NetworkManagementClientImpl client;

    public FirewallPolicyRuleGroupsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (FirewallPolicyRuleGroupsService)retrofit.create(FirewallPolicyRuleGroupsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallPolicyRuleGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FirewallPolicyRuleGroupInner get(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        return (FirewallPolicyRuleGroupInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<FirewallPolicyRuleGroupInner> getAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, ServiceCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName), serviceCallback);
    }

    public Observable<FirewallPolicyRuleGroupInner> getAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName).map((Func1)new Func1<ServiceResponse<FirewallPolicyRuleGroupInner>, FirewallPolicyRuleGroupInner>(){

            public FirewallPolicyRuleGroupInner call(ServiceResponse<FirewallPolicyRuleGroupInner> response) {
                return (FirewallPolicyRuleGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallPolicyRuleGroupInner>>>(){

            public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallPolicyRuleGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallPolicyRuleGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallPolicyRuleGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FirewallPolicyRuleGroupInner createOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        return (FirewallPolicyRuleGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<FirewallPolicyRuleGroupInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters, ServiceCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters), serviceCallback);
    }

    public Observable<FirewallPolicyRuleGroupInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters).map((Func1)new Func1<ServiceResponse<FirewallPolicyRuleGroupInner>, FirewallPolicyRuleGroupInner>(){

            public FirewallPolicyRuleGroupInner call(ServiceResponse<FirewallPolicyRuleGroupInner> response) {
                return (FirewallPolicyRuleGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FirewallPolicyRuleGroupInner>(){}.getType());
    }

    public FirewallPolicyRuleGroupInner beginCreateOrUpdate(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        return (FirewallPolicyRuleGroupInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<FirewallPolicyRuleGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters, ServiceCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters), serviceCallback);
    }

    public Observable<FirewallPolicyRuleGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, ruleGroupName, parameters).map((Func1)new Func1<ServiceResponse<FirewallPolicyRuleGroupInner>, FirewallPolicyRuleGroupInner>(){

            public FirewallPolicyRuleGroupInner call(ServiceResponse<FirewallPolicyRuleGroupInner> response) {
                return (FirewallPolicyRuleGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String ruleGroupName, FirewallPolicyRuleGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (ruleGroupName == null) {
            throw new IllegalArgumentException("Parameter ruleGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, firewallPolicyName, ruleGroupName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallPolicyRuleGroupInner>>>(){

            public Observable<ServiceResponse<FirewallPolicyRuleGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallPolicyRuleGroupsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallPolicyRuleGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallPolicyRuleGroupInner>(){}.getType()).register(201, new TypeToken<FirewallPolicyRuleGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FirewallPolicyRuleGroupInner> list(String resourceGroupName, String firewallPolicyName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, firewallPolicyName).toBlocking().single();
        return new PagedList<FirewallPolicyRuleGroupInner>((Page)response.body()){

            public Page<FirewallPolicyRuleGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallPolicyRuleGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FirewallPolicyRuleGroupInner>> listAsync(String resourceGroupName, String firewallPolicyName, ListOperationCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, firewallPolicyName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(String nextPageLink) {
                return FirewallPolicyRuleGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FirewallPolicyRuleGroupInner>> listAsync(String resourceGroupName, String firewallPolicyName) {
        return this.listWithServiceResponseAsync(resourceGroupName, firewallPolicyName).map((Func1)new Func1<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>, Page<FirewallPolicyRuleGroupInner>>(){

            public Page<FirewallPolicyRuleGroupInner> call(ServiceResponse<Page<FirewallPolicyRuleGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> listWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName) {
        return this.listSinglePageAsync(resourceGroupName, firewallPolicyName).concatMap((Func1)new Func1<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(ServiceResponse<Page<FirewallPolicyRuleGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallPolicyRuleGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> listSinglePageAsync(String resourceGroupName, String firewallPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, firewallPolicyName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallPolicyRuleGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallPolicyRuleGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FirewallPolicyRuleGroupInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FirewallPolicyRuleGroupInner>((Page)response.body()){

            public Page<FirewallPolicyRuleGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallPolicyRuleGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FirewallPolicyRuleGroupInner>> listNextAsync(String nextPageLink, ServiceFuture<List<FirewallPolicyRuleGroupInner>> serviceFuture, ListOperationCallback<FirewallPolicyRuleGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(String nextPageLink) {
                return FirewallPolicyRuleGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FirewallPolicyRuleGroupInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>, Page<FirewallPolicyRuleGroupInner>>(){

            public Page<FirewallPolicyRuleGroupInner> call(ServiceResponse<Page<FirewallPolicyRuleGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(ServiceResponse<Page<FirewallPolicyRuleGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallPolicyRuleGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyRuleGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallPolicyRuleGroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallPolicyRuleGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallPolicyRuleGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FirewallPolicyRuleGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="ruleGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="ruleGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="ruleGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="ruleGroupName") String var3, @Path(value="subscriptionId") String var4, @Body FirewallPolicyRuleGroupInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="ruleGroupName") String var3, @Path(value="subscriptionId") String var4, @Body FirewallPolicyRuleGroupInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicyRuleGroups listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

