/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.AvailableDelegationInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AvailableDelegationsInner {
    private AvailableDelegationsService service;
    private NetworkManagementClientImpl client;

    public AvailableDelegationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (AvailableDelegationsService)retrofit.create(AvailableDelegationsService.class);
        this.client = client;
    }

    public PagedList<AvailableDelegationInner> list(String location) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(location).toBlocking().single();
        return new PagedList<AvailableDelegationInner>((Page)response.body()){

            public Page<AvailableDelegationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailableDelegationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailableDelegationInner>> listAsync(String location, ListOperationCallback<AvailableDelegationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailableDelegationInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableDelegationInner>>> call(String nextPageLink) {
                return AvailableDelegationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailableDelegationInner>> listAsync(String location) {
        return this.listWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<AvailableDelegationInner>>, Page<AvailableDelegationInner>>(){

            public Page<AvailableDelegationInner> call(ServiceResponse<Page<AvailableDelegationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableDelegationInner>>> listWithServiceResponseAsync(String location) {
        return this.listSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<AvailableDelegationInner>>, Observable<ServiceResponse<Page<AvailableDelegationInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableDelegationInner>>> call(ServiceResponse<Page<AvailableDelegationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailableDelegationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableDelegationInner>>> listSinglePageAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(location, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailableDelegationInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableDelegationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailableDelegationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailableDelegationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailableDelegationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AvailableDelegationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AvailableDelegationInner>((Page)response.body()){

            public Page<AvailableDelegationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailableDelegationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailableDelegationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<AvailableDelegationInner>> serviceFuture, ListOperationCallback<AvailableDelegationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailableDelegationInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableDelegationInner>>> call(String nextPageLink) {
                return AvailableDelegationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailableDelegationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AvailableDelegationInner>>, Page<AvailableDelegationInner>>(){

            public Page<AvailableDelegationInner> call(ServiceResponse<Page<AvailableDelegationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableDelegationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AvailableDelegationInner>>, Observable<ServiceResponse<Page<AvailableDelegationInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableDelegationInner>>> call(ServiceResponse<Page<AvailableDelegationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailableDelegationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableDelegationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailableDelegationInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableDelegationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailableDelegationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailableDelegationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailableDelegationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AvailableDelegationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailableDelegations list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/availableDelegations")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailableDelegations listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

