/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.ApplicationSecurityGroupInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ApplicationSecurityGroupsInner
implements InnerSupportsGet<ApplicationSecurityGroupInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ApplicationSecurityGroupInner> {
    private ApplicationSecurityGroupsService service;
    private NetworkManagementClientImpl client;

    public ApplicationSecurityGroupsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ApplicationSecurityGroupsService)retrofit.create(ApplicationSecurityGroupsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String applicationSecurityGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String applicationSecurityGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String applicationSecurityGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String applicationSecurityGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationSecurityGroupName == null) {
            throw new IllegalArgumentException("Parameter applicationSecurityGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, applicationSecurityGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String applicationSecurityGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String applicationSecurityGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String applicationSecurityGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String applicationSecurityGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationSecurityGroupName == null) {
            throw new IllegalArgumentException("Parameter applicationSecurityGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, applicationSecurityGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationSecurityGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationSecurityGroupInner getByResourceGroup(String resourceGroupName, String applicationSecurityGroupName) {
        return (ApplicationSecurityGroupInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationSecurityGroupInner> getByResourceGroupAsync(String resourceGroupName, String applicationSecurityGroupName, ServiceCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName), serviceCallback);
    }

    public Observable<ApplicationSecurityGroupInner> getByResourceGroupAsync(String resourceGroupName, String applicationSecurityGroupName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName).map((Func1)new Func1<ServiceResponse<ApplicationSecurityGroupInner>, ApplicationSecurityGroupInner>(){

            public ApplicationSecurityGroupInner call(ServiceResponse<ApplicationSecurityGroupInner> response) {
                return (ApplicationSecurityGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationSecurityGroupInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String applicationSecurityGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationSecurityGroupName == null) {
            throw new IllegalArgumentException("Parameter applicationSecurityGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, applicationSecurityGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationSecurityGroupInner>>>(){

            public Observable<ServiceResponse<ApplicationSecurityGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationSecurityGroupsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationSecurityGroupInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationSecurityGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationSecurityGroupInner createOrUpdate(String resourceGroupName, String applicationSecurityGroupName, ApplicationSecurityGroupInner parameters) {
        return (ApplicationSecurityGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ApplicationSecurityGroupInner> createOrUpdateAsync(String resourceGroupName, String applicationSecurityGroupName, ApplicationSecurityGroupInner parameters, ServiceCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, parameters), serviceCallback);
    }

    public Observable<ApplicationSecurityGroupInner> createOrUpdateAsync(String resourceGroupName, String applicationSecurityGroupName, ApplicationSecurityGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, parameters).map((Func1)new Func1<ServiceResponse<ApplicationSecurityGroupInner>, ApplicationSecurityGroupInner>(){

            public ApplicationSecurityGroupInner call(ServiceResponse<ApplicationSecurityGroupInner> response) {
                return (ApplicationSecurityGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationSecurityGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String applicationSecurityGroupName, ApplicationSecurityGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationSecurityGroupName == null) {
            throw new IllegalArgumentException("Parameter applicationSecurityGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, applicationSecurityGroupName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ApplicationSecurityGroupInner>(){}.getType());
    }

    public ApplicationSecurityGroupInner beginCreateOrUpdate(String resourceGroupName, String applicationSecurityGroupName, ApplicationSecurityGroupInner parameters) {
        return (ApplicationSecurityGroupInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationSecurityGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String applicationSecurityGroupName, ApplicationSecurityGroupInner parameters, ServiceCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, parameters), serviceCallback);
    }

    public Observable<ApplicationSecurityGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String applicationSecurityGroupName, ApplicationSecurityGroupInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, parameters).map((Func1)new Func1<ServiceResponse<ApplicationSecurityGroupInner>, ApplicationSecurityGroupInner>(){

            public ApplicationSecurityGroupInner call(ServiceResponse<ApplicationSecurityGroupInner> response) {
                return (ApplicationSecurityGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationSecurityGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String applicationSecurityGroupName, ApplicationSecurityGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationSecurityGroupName == null) {
            throw new IllegalArgumentException("Parameter applicationSecurityGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, applicationSecurityGroupName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationSecurityGroupInner>>>(){

            public Observable<ServiceResponse<ApplicationSecurityGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationSecurityGroupsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationSecurityGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationSecurityGroupInner>(){}.getType()).register(201, new TypeToken<ApplicationSecurityGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationSecurityGroupInner updateTags(String resourceGroupName, String applicationSecurityGroupName) {
        return (ApplicationSecurityGroupInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationSecurityGroupInner> updateTagsAsync(String resourceGroupName, String applicationSecurityGroupName, ServiceCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName), serviceCallback);
    }

    public Observable<ApplicationSecurityGroupInner> updateTagsAsync(String resourceGroupName, String applicationSecurityGroupName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName).map((Func1)new Func1<ServiceResponse<ApplicationSecurityGroupInner>, ApplicationSecurityGroupInner>(){

            public ApplicationSecurityGroupInner call(ServiceResponse<ApplicationSecurityGroupInner> response) {
                return (ApplicationSecurityGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationSecurityGroupInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String applicationSecurityGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationSecurityGroupName == null) {
            throw new IllegalArgumentException("Parameter applicationSecurityGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.updateTags(resourceGroupName, applicationSecurityGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationSecurityGroupInner>>>(){

            public Observable<ServiceResponse<ApplicationSecurityGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationSecurityGroupsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationSecurityGroupInner updateTags(String resourceGroupName, String applicationSecurityGroupName, Map<String, String> tags) {
        return (ApplicationSecurityGroupInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationSecurityGroupInner> updateTagsAsync(String resourceGroupName, String applicationSecurityGroupName, Map<String, String> tags, ServiceCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, tags), serviceCallback);
    }

    public Observable<ApplicationSecurityGroupInner> updateTagsAsync(String resourceGroupName, String applicationSecurityGroupName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, applicationSecurityGroupName, tags).map((Func1)new Func1<ServiceResponse<ApplicationSecurityGroupInner>, ApplicationSecurityGroupInner>(){

            public ApplicationSecurityGroupInner call(ServiceResponse<ApplicationSecurityGroupInner> response) {
                return (ApplicationSecurityGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationSecurityGroupInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String applicationSecurityGroupName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (applicationSecurityGroupName == null) {
            throw new IllegalArgumentException("Parameter applicationSecurityGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.updateTags(resourceGroupName, applicationSecurityGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationSecurityGroupInner>>>(){

            public Observable<ServiceResponse<ApplicationSecurityGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationSecurityGroupsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationSecurityGroupInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationSecurityGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationSecurityGroupInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationSecurityGroupInner>((Page)response.body()){

            public Page<ApplicationSecurityGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationSecurityGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationSecurityGroupInner>> listAsync(ListOperationCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(String nextPageLink) {
                return ApplicationSecurityGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationSecurityGroupInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ApplicationSecurityGroupInner>>, Page<ApplicationSecurityGroupInner>>(){

            public Page<ApplicationSecurityGroupInner> call(ServiceResponse<Page<ApplicationSecurityGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationSecurityGroupInner>>, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(ServiceResponse<Page<ApplicationSecurityGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationSecurityGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationSecurityGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationSecurityGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationSecurityGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationSecurityGroupInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ApplicationSecurityGroupInner>((Page)response.body()){

            public Page<ApplicationSecurityGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationSecurityGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationSecurityGroupInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(String nextPageLink) {
                return ApplicationSecurityGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationSecurityGroupInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ApplicationSecurityGroupInner>>, Page<ApplicationSecurityGroupInner>>(){

            public Page<ApplicationSecurityGroupInner> call(ServiceResponse<Page<ApplicationSecurityGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationSecurityGroupInner>>, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(ServiceResponse<Page<ApplicationSecurityGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationSecurityGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationSecurityGroupsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationSecurityGroupInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationSecurityGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationSecurityGroupInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationSecurityGroupInner>((Page)response.body()){

            public Page<ApplicationSecurityGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationSecurityGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationSecurityGroupInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ApplicationSecurityGroupInner>> serviceFuture, ListOperationCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(String nextPageLink) {
                return ApplicationSecurityGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationSecurityGroupInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationSecurityGroupInner>>, Page<ApplicationSecurityGroupInner>>(){

            public Page<ApplicationSecurityGroupInner> call(ServiceResponse<Page<ApplicationSecurityGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationSecurityGroupInner>>, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(ServiceResponse<Page<ApplicationSecurityGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationSecurityGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationSecurityGroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationSecurityGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationSecurityGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationSecurityGroupInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationSecurityGroupInner>((Page)response.body()){

            public Page<ApplicationSecurityGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationSecurityGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationSecurityGroupInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ApplicationSecurityGroupInner>> serviceFuture, ListOperationCallback<ApplicationSecurityGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(String nextPageLink) {
                return ApplicationSecurityGroupsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationSecurityGroupInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationSecurityGroupInner>>, Page<ApplicationSecurityGroupInner>>(){

            public Page<ApplicationSecurityGroupInner> call(ServiceResponse<Page<ApplicationSecurityGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationSecurityGroupInner>>, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(ServiceResponse<Page<ApplicationSecurityGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationSecurityGroupsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationSecurityGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationSecurityGroupsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationSecurityGroupInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationSecurityGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ApplicationSecurityGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="applicationSecurityGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="applicationSecurityGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="applicationSecurityGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="applicationSecurityGroupName") String var2, @Path(value="subscriptionId") String var3, @Body ApplicationSecurityGroupInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="applicationSecurityGroupName") String var2, @Path(value="subscriptionId") String var3, @Body ApplicationSecurityGroupInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="applicationSecurityGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationSecurityGroups")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ApplicationSecurityGroups listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

