/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.network.BgpSettings;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PointToSiteConfiguration;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnection;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnections;
import com.microsoft.azure.management.network.VirtualNetworkGatewayIPConfiguration;
import com.microsoft.azure.management.network.VirtualNetworkGatewaySku;
import com.microsoft.azure.management.network.VirtualNetworkGatewaySkuName;
import com.microsoft.azure.management.network.VirtualNetworkGatewayType;
import com.microsoft.azure.management.network.VpnClientConfiguration;
import com.microsoft.azure.management.network.VpnType;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayInner;
import com.microsoft.azure.management.network.model.HasPublicIPAddress;
import com.microsoft.azure.management.network.model.UpdatableWithTags;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Collection;
import rx.Completable;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_3_0)
public interface VirtualNetworkGateway
extends GroupableResource<NetworkManager, VirtualNetworkGatewayInner>,
Refreshable<VirtualNetworkGateway>,
Updatable<Update>,
UpdatableWithTags<VirtualNetworkGateway> {
    @Method
    public void reset();

    @Method
    public Completable resetAsync();

    @Method
    public PagedList<VirtualNetworkGatewayConnection> listConnections();

    @Method
    public Observable<VirtualNetworkGatewayConnection> listConnectionsAsync();

    @Method
    public String generateVpnProfile();

    @Method
    public Observable<String> generateVpnProfileAsync();

    public VirtualNetworkGatewayConnections connections();

    public VirtualNetworkGatewayType gatewayType();

    public VpnType vpnType();

    public boolean isBgpEnabled();

    public boolean activeActive();

    public String gatewayDefaultSiteResourceId();

    public VirtualNetworkGatewaySku sku();

    public VpnClientConfiguration vpnClientConfiguration();

    public BgpSettings bgpSettings();

    public Collection<VirtualNetworkGatewayIPConfiguration> ipConfigurations();

    public static interface Update
    extends Appliable<VirtualNetworkGateway>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithBgp,
    UpdateStages.WithPointToSiteConfiguration {
    }

    public static interface UpdateStages {

        public static interface WithPointToSiteConfiguration {
            public PointToSiteConfiguration.DefinitionStages.Blank<Update> definePointToSiteConfiguration();

            public PointToSiteConfiguration.Update updatePointToSiteConfiguration();
        }

        public static interface WithBgp {
            public Update withBgp(long var1, String var3);

            @Method
            public Update withoutBgp();
        }

        public static interface WithSku {
            public Update withSku(VirtualNetworkGatewaySkuName var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<VirtualNetworkGateway>,
        Resource.DefinitionWithTags<WithCreate>,
        WithPublicIPAddress,
        WithBgp {
        }

        public static interface WithBgp {
            public WithCreate withBgp(long var1, String var3);
        }

        public static interface WithPublicIPAddress
        extends HasPublicIPAddress.DefinitionStages.WithPublicIPAddressNoDnsLabel<WithCreate> {
        }

        public static interface WithSku {
            public WithCreate withSku(VirtualNetworkGatewaySkuName var1);
        }

        public static interface WithNetwork {
            public WithGatewayType withNewNetwork(Creatable<Network> var1);

            public WithGatewayType withNewNetwork(String var1, String var2, String var3);

            public WithGatewayType withNewNetwork(String var1, String var2);

            public WithGatewayType withExistingNetwork(Network var1);
        }

        public static interface WithGatewayType {
            public WithSku withExpressRoute();

            public WithSku withRouteBasedVpn();

            public WithCreate withPolicyBasedVpn();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithNetwork> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithGatewayType,
    DefinitionStages.WithSku,
    DefinitionStages.WithNetwork,
    DefinitionStages.WithBgp,
    DefinitionStages.WithCreate {
    }
}

